/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.lazy;

import adams.core.ObjectCopyHelper;
import adams.core.Range;
import adams.core.Utils;
import adams.core.logging.CustomLoggingLevelObject;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import adams.core.option.OptionUtils;
import gnu.trove.list.array.TIntArrayList;
import java.io.Serializable;
import java.util.logging.Level;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.neighboursearch.LinearNNSearch;
import weka.core.neighboursearch.NearestNeighbourSearch;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.AddID;

public class LWLDatasetBuilder
extends CustomLoggingLevelObject {
    private static final long serialVersionUID = 246129751885426502L;
    protected Instances m_Train = null;
    protected transient Instances m_ActualTrain;
    protected int m_kNN = -1;
    protected int m_WeightKernel = 0;
    protected boolean m_UseAllK = true;
    protected NearestNeighbourSearch m_Search = new LinearNNSearch();
    protected transient NearestNeighbourSearch m_ActualSearch;
    protected boolean m_NoUpdate = false;
    protected transient AddID m_AddID;

    protected void reset() {
        this.m_ActualSearch = null;
        this.m_ActualTrain = null;
        this.m_AddID = null;
    }

    public void setKNN(int value) {
        this.m_kNN = value;
        if (value <= 0) {
            this.m_kNN = 0;
            this.m_UseAllK = true;
        } else {
            this.m_UseAllK = false;
        }
        this.reset();
    }

    public int getKNN() {
        return this.m_kNN;
    }

    public void setWeightingKernel(int value) {
        if (value != 0 && value != 1 && value != 2 && value != 3 && value != 4 && value != 5) {
            return;
        }
        this.m_WeightKernel = value;
        this.reset();
    }

    public int getWeightingKernel() {
        return this.m_WeightKernel;
    }

    public void setSearchAlgorithm(NearestNeighbourSearch value) {
        this.m_Search = value;
        this.reset();
    }

    public NearestNeighbourSearch getSearchAlgorithm() {
        return this.m_Search;
    }

    public void setNoUpdate(boolean value) {
        this.m_NoUpdate = value;
        this.reset();
    }

    public boolean getNoUpdate() {
        return this.m_NoUpdate;
    }

    public void setTrain(Instances value) {
        this.m_Train = value;
        this.reset();
    }

    public Instances getTrain() {
        return this.m_Train;
    }

    protected String getIDAttributeName(Instances data) {
        String result = "ID";
        if (data.attribute(result) == null) {
            return result;
        }
        int count = 0;
        while (data.attribute(result + "-" + ++count) != null) {
        }
        result = result + "-" + count;
        return result;
    }

    public LWLContainer build(Instance instance) throws Exception {
        Instance inst;
        double bandwidth;
        int i;
        if (this.m_ActualSearch == null) {
            this.m_AddID = new AddID();
            this.m_AddID.setAttributeName(this.getIDAttributeName(this.m_Train));
            this.m_AddID.setIDIndex("" + (this.m_Train.numAttributes() + 1));
            this.m_AddID.setInputFormat(this.m_Train);
            this.m_ActualTrain = Filter.useFilter((Instances)this.m_Train, (Filter)this.m_AddID);
            this.m_ActualSearch = (NearestNeighbourSearch)ObjectCopyHelper.copyObject((Object)this.m_Search);
            if (this.m_Search.getDistanceFunction().getAttributeIndices().equals("first-last") && !this.m_Search.getDistanceFunction().getInvertSelection()) {
                this.m_ActualSearch.getDistanceFunction().setAttributeIndices("1-" + this.m_Train.numAttributes());
            } else {
                Range range = new Range(this.m_Search.getDistanceFunction().getAttributeIndices());
                range.setInverted(this.m_Search.getDistanceFunction().getInvertSelection());
                TIntArrayList rangeList = new TIntArrayList(range.getIntIndices());
                rangeList.remove(this.m_Train.numAttributes());
                range.setIndices(rangeList.toArray());
                this.m_ActualSearch.getDistanceFunction().setAttributeIndices(range.toExplicitRange());
                this.m_ActualSearch.getDistanceFunction().setInvertSelection(false);
            }
            this.m_ActualSearch.setInstances(this.m_ActualTrain);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Actual search: " + OptionUtils.getCommandLine((Object)this.m_ActualSearch));
            }
        }
        this.m_AddID.input(instance);
        this.m_AddID.batchFinished();
        Instance actualInstance = this.m_AddID.output();
        if (!this.m_NoUpdate) {
            this.m_ActualSearch.addInstanceInfo(actualInstance);
        }
        int k = this.m_Train.numInstances();
        if (!this.m_UseAllK && this.m_kNN < k) {
            k = this.m_kNN;
        }
        Instances weighted = this.m_ActualSearch.kNearestNeighbours(actualInstance, k);
        double[] distances = this.m_ActualSearch.getDistances();
        if (LoggingHelper.isAtLeast((Logger)this.getLogger(), (Level)Level.FINE)) {
            this.getLogger().fine("Test Instance: " + instance);
            this.getLogger().fine("For " + k + " kept " + weighted.numInstances() + " out of " + this.m_Train.numInstances() + " instances.");
        }
        if (k > distances.length) {
            k = distances.length;
        }
        if (LoggingHelper.isAtLeast((Logger)this.getLogger(), (Level)Level.FINE)) {
            this.getLogger().fine("Instance Distances");
            for (i = 0; i < distances.length; ++i) {
                this.getLogger().fine(i + 1 + ". " + distances[i]);
            }
        }
        if ((bandwidth = distances[k - 1]) <= 0.0) {
            for (i = 0; i < distances.length; ++i) {
                distances[i] = 1.0;
            }
        } else {
            for (i = 0; i < distances.length; ++i) {
                distances[i] = distances[i] / bandwidth;
            }
        }
        block11: for (i = 0; i < distances.length; ++i) {
            switch (this.m_WeightKernel) {
                case 0: {
                    distances[i] = 1.0001 - distances[i];
                    continue block11;
                }
                case 1: {
                    distances[i] = 0.75 * (1.0001 - distances[i] * distances[i]);
                    continue block11;
                }
                case 2: {
                    distances[i] = Math.pow(1.0001 - Math.pow(distances[i], 3.0), 3.0);
                    continue block11;
                }
                case 5: {
                    distances[i] = 1.0;
                    continue block11;
                }
                case 3: {
                    distances[i] = 1.0 / (1.0 + distances[i]);
                    continue block11;
                }
                case 4: {
                    distances[i] = Math.exp(-distances[i] * distances[i]);
                }
            }
        }
        if (LoggingHelper.isAtLeast((Logger)this.getLogger(), (Level)Level.FINE)) {
            this.getLogger().fine("Instance Weights");
            for (i = 0; i < distances.length; ++i) {
                this.getLogger().fine(i + 1 + ". " + distances[i]);
            }
        }
        double sumOfWeights = 0.0;
        double newSumOfWeights = 0.0;
        for (i = 0; i < distances.length; ++i) {
            double weight = distances[i];
            inst = weighted.instance(i);
            sumOfWeights += inst.weight();
            newSumOfWeights += inst.weight() * weight;
            inst.setWeight(inst.weight() * weight);
        }
        for (i = 0; i < weighted.numInstances(); ++i) {
            inst = weighted.instance(i);
            inst.setWeight(inst.weight() * sumOfWeights / newSumOfWeights);
        }
        TIntArrayList indices = new TIntArrayList();
        for (i = 0; i < weighted.numInstances(); ++i) {
            indices.add((int)weighted.instance(i).value(weighted.numAttributes() - 1) - 1);
        }
        LWLContainer result = new LWLContainer();
        result.distances = (double[])distances.clone();
        result.originalIndices = indices.toArray();
        result.dataset = new Instances(this.m_Train, indices.size());
        for (i = 0; i < indices.size(); ++i) {
            inst = (Instance)this.m_Train.instance(indices.get(i)).copy();
            inst.setWeight(weighted.instance(i).weight() * sumOfWeights / newSumOfWeights);
            result.dataset.add(inst);
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("kNN: " + this.m_kNN + "\n");
        result.append("Weighting Kernel: " + this.m_WeightKernel + "\n");
        result.append("Search: " + OptionUtils.getCommandLine((Object)this.m_Search) + "\n");
        result.append("No update: " + this.m_NoUpdate + "\n");
        return result.toString();
    }

    public static class LWLContainer
    implements Serializable {
        private static final long serialVersionUID = 5090533464519863032L;
        public Instances dataset;
        public double[] distances;
        public int[] originalIndices;

        public String toString() {
            return "Dataset: " + this.dataset.numInstances() + " rows\nDistances: " + Utils.arrayToString((Object)this.distances) + "\nOriginal indices: " + Utils.arrayToString((Object)this.originalIndices);
        }
    }
}

