/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import adams.core.Range;
import adams.data.statistics.Percentile;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weka.classifiers.AbstainingClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.meta.LeastMedianSq;
import weka.core.AttributeStats;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.experiment.Stats;

public class AbstainAttributePercentile
extends SingleClassifierEnhancer
implements WeightedInstancesHandler,
AbstainingClassifier {
    private static final long serialVersionUID = 3063502797829542418L;
    protected Instances m_Data;
    protected int m_attnum = 1;
    protected boolean m_debug = false;
    protected double m_pctile = 0.98;
    protected boolean m_ok = true;
    protected boolean m_removetrain = false;
    protected double m_min;
    protected double m_max;
    protected Hashtable<Integer, double[]> m_Ranges = new Hashtable();
    protected Range m_Range = new Range("first-last");

    public String globalInfo() {
        return "Only predict if attribute value within percentile range. Ensure same for training set if req.";
    }

    public Enumeration listOptions() {
        Vector newVector = new Vector();
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        newVector.addElement(new Option("\tAttribute Range to check\n\t(default: 1)\n", "S", 1, "-S <sint>"));
        newVector.addElement(new Option("\tPercentile\n\t(default: 0.98)\n", "P", 1, "-P <double>"));
        newVector.addElement(new Option("\tApply to Train\n\t(default: false)\n", "E", 0, "-E"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String curropt = Utils.getOption((char)'S', (String[])options);
        if (curropt.length() != 0) {
            this.setAttribute(curropt);
        } else {
            this.setAttribute("first-last");
        }
        curropt = Utils.getOption((char)'P', (String[])options);
        if (curropt.length() != 0) {
            this.setPercentile(Double.parseDouble(curropt));
        } else {
            this.setPercentile(0.98);
        }
        this.setRemoveTrain(Utils.getFlag((char)'E', (String[])options));
        super.setOptions(options);
    }

    public String[] getOptions() {
        String[] options;
        ArrayList<String> result = new ArrayList<String>();
        result.add("-S");
        result.add("" + this.getAttribute());
        result.add("-P");
        result.add("" + this.getPercentile());
        if (this.getRemoveTrain()) {
            result.add("-E");
        }
        for (String option : options = super.getOptions()) {
            result.add(option);
        }
        return result.toArray(new String[result.size()]);
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.setMinimumNumberInstances(1);
        result.disable(Capabilities.Capability.NOMINAL_CLASS);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        this.m_Range.setMax(data.numAttributes());
        for (int i = 0; i < data.numAttributes(); ++i) {
            if (!this.m_Range.isInRange(i) || data.classIndex() == i) continue;
            double[] dats = data.attributeToDoubleArray(i);
            Percentile p = new Percentile();
            for (double d : dats) {
                p.add((Comparable)Double.valueOf(d));
            }
            double[] minmax = new double[]{(Double)p.getPercentile(1.0 - this.getPercentile()), (Double)p.getPercentile(this.getPercentile())};
            this.m_Ranges.put(i, minmax);
        }
        this.m_ok = false;
        if (this.getRemoveTrain()) {
            this.m_Data = new Instances(data, 100);
            for (Instance in : data) {
                boolean inside = true;
                for (int i = 0; i < data.numAttributes(); ++i) {
                    if (!this.m_Range.isInRange(i) || data.classIndex() == i) continue;
                    double val = in.value(i);
                    double[] minmax = this.m_Ranges.get(i);
                    if (minmax == null) {
                        System.err.println("Got no minmax for:" + i);
                        continue;
                    }
                    if (!(val < minmax[0]) && !(val > minmax[1])) continue;
                    inside = false;
                    break;
                }
                if (!inside) continue;
                this.m_Data.add(in);
                this.m_ok = true;
            }
        } else {
            this.m_Data = data;
            this.m_ok = true;
        }
        if (this.m_ok) {
            this.m_Classifier.buildClassifier(this.m_Data);
        }
        AttributeStats as = data.attributeStats(this.m_Data.classIndex());
        Stats s = as.numericStats;
        this.m_min = s.min;
        this.m_max = s.max;
    }

    public double classifyInstance(Instance inst) throws Exception {
        for (int i = 0; i < inst.numAttributes(); ++i) {
            if (!this.m_Range.isInRange(i) || inst.classIndex() == i) continue;
            double val = inst.value(i);
            double[] minmax = this.m_Ranges.get(i);
            if (minmax == null) {
                System.err.println("Got no minmax for:" + i);
                continue;
            }
            if (!(val < minmax[0]) && !(val > minmax[1])) continue;
            return Utils.missingValue();
        }
        double res = this.m_Classifier.classifyInstance(inst);
        if (Utils.isMissingValue((double)res) || res < this.m_min || res > this.m_max) {
            return Utils.missingValue();
        }
        return res;
    }

    @Override
    public boolean canAbstain() {
        return true;
    }

    @Override
    public double getAbstentionClassification(Instance inst) throws Exception {
        if (this.m_Classifier instanceof AbstainingClassifier) {
            return ((AbstainingClassifier)this.m_Classifier).getAbstentionClassification(inst);
        }
        return this.m_Classifier.classifyInstance(inst);
    }

    @Override
    public double[] getAbstentionDistribution(Instance inst) throws Exception {
        if (this.m_Classifier instanceof AbstainingClassifier) {
            return ((AbstainingClassifier)this.m_Classifier).getAbstentionDistribution(inst);
        }
        return this.m_Classifier.distributionForInstance(inst);
    }

    public String toString() {
        return this.m_Classifier.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public void setPercentile(double var) {
        this.m_pctile = var;
    }

    public double getPercentile() {
        return this.m_pctile;
    }

    public String percentileTipText() {
        return "percentile of attribute values";
    }

    public void setAttribute(String at) {
        this.m_Range = new Range(at);
    }

    public String getAttribute() {
        return this.m_Range.getRange();
    }

    public String attributeTipText() {
        return "Attributes to operate on";
    }

    public void setRemoveTrain(boolean t) {
        this.m_removetrain = t;
    }

    public boolean getRemoveTrain() {
        return this.m_removetrain;
    }

    public String removeTrainTipText() {
        return "Whether to remove data outside the percentile from the training data.";
    }

    public static void main(String[] argv) {
        AbstainAttributePercentile.runClassifier((Classifier)new LeastMedianSq(), (String[])argv);
    }
}

