/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstainingClassifier;
import weka.classifiers.SingleClassifierEnhancer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.WekaOptionUtils;

public class AbstainMinimumProbability
extends SingleClassifierEnhancer
implements AbstainingClassifier {
    private static final long serialVersionUID = 5699323936859571421L;
    public static final String MIN_PROBABILITY = "min-probability";
    protected double m_MinProbability = this.getDefaultMinProbability();
    protected int m_NumLabels;

    public String globalInfo() {
        return "Abstains if the probability of the chosen class label is below the specified threshold.";
    }

    protected double getDefaultMinProbability() {
        return 0.8;
    }

    public void setMinProbability(double value) {
        if (value >= 0.0 && value <= 1.0) {
            this.m_MinProbability = value;
        } else {
            System.err.println("Min probability must meet 0 < x < 1, provided: " + value);
        }
    }

    public double getMinProbability() {
        return this.m_MinProbability;
    }

    public String minProbabilityTipText() {
        return "The minimum probability that the chosen label must meet.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, this.minProbabilityTipText(), "" + this.getDefaultMinProbability(), MIN_PROBABILITY);
        WekaOptionUtils.add(result, super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    public void setOptions(String[] options) throws Exception {
        this.setMinProbability(WekaOptionUtils.parse(options, MIN_PROBABILITY, this.getDefaultMinProbability()));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, MIN_PROBABILITY, this.getMinProbability());
        WekaOptionUtils.add(result, super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disable(Capabilities.Capability.DATE_CLASS);
        result.disable(Capabilities.Capability.NUMERIC_CLASS);
        result.disable(Capabilities.Capability.RELATIONAL_CLASS);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_Classifier.buildClassifier(data);
        this.m_NumLabels = data.classAttribute().numValues();
    }

    @Override
    public boolean canAbstain() {
        return true;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] result = this.m_Classifier.distributionForInstance(instance);
        double max = result[Utils.maxIndex((double[])result)];
        if (max < this.m_MinProbability) {
            return new double[this.m_NumLabels];
        }
        return result;
    }

    @Override
    public double getAbstentionClassification(Instance inst) throws Exception {
        if (this.m_Classifier instanceof AbstainingClassifier) {
            return ((AbstainingClassifier)this.m_Classifier).getAbstentionClassification(inst);
        }
        return this.m_Classifier.classifyInstance(inst);
    }

    @Override
    public double[] getAbstentionDistribution(Instance inst) throws Exception {
        if (this.m_Classifier instanceof AbstainingClassifier) {
            return ((AbstainingClassifier)this.m_Classifier).getAbstentionDistribution(inst);
        }
        return this.m_Classifier.distributionForInstance(inst);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "\n");
        result.append(this.getClass().getSimpleName().replaceAll(".", "=") + "\n");
        result.append("\n");
        result.append("Minimum probability: " + this.m_MinProbability + "\n");
        result.append("\n");
        result.append(this.m_Classifier.toString());
        return result.toString();
    }
}

