/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.neighboursearch.NewNNSearch;
import weka.core.neighboursearch.TransformNNSearch;
import weka.filters.Filter;
import weka.filters.supervised.attribute.AttributeSelection;
import weka.filters.supervised.attribute.Discretize;

public class FilteredSearch
extends TransformNNSearch {
    private static final long serialVersionUID = -7892640764629075977L;
    protected Filter m_Filter = new AttributeSelection();

    public FilteredSearch() {
    }

    protected Instances transformInstances(Instances in) throws Exception {
        Instances ret = null;
        this.m_Filter.setInputFormat(in);
        ret = Filter.useFilter((Instances)in, (Filter)this.m_Filter);
        return ret;
    }

    @Override
    public Instance transformInstance(Instance in) throws Exception {
        this.m_Filter.input(in);
        this.m_Filter.batchFinished();
        return this.m_Filter.output();
    }

    public FilteredSearch(Instances insts) {
        super(insts);
        try {
            Instances t_instances;
            this.m_Instances = insts;
            this.m_myInstances = t_instances = this.transformInstances(insts);
            this.m_DistanceFunction.setInstances(t_instances);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Instances kNearestNeighbours(Instance target, int kNN) throws Exception {
        if (this.m_Stats != null) {
            this.m_Stats.searchStart();
        }
        this.m_neighbours.clear();
        double last_distance = Double.POSITIVE_INFINITY;
        Instance t_instance = this.transformInstance(target);
        for (int i = 0; i < this.m_Instances.numInstances(); ++i) {
            double distance;
            if (target == this.m_Instances.instance(i)) continue;
            if (this.m_Stats != null) {
                this.m_Stats.incrPointCount();
            }
            if ((distance = this.m_DistanceFunction.distance(t_instance, this.m_myInstances.instance(i), last_distance, this.m_Stats)) == 0.0 && this.m_SkipIdentical || !(distance < last_distance)) continue;
            this.m_neighbours.add((Object)new NewNNSearch.InstanceNode(this, i, distance));
            if (this.m_neighbours.size() <= kNN) continue;
            this.m_neighbours.remove(this.m_neighbours.size() - 1);
            last_distance = ((NewNNSearch.InstanceNode)this.m_neighbours.get((int)(this.m_neighbours.size() - 1))).distance;
        }
        Instances neighbours = new Instances(this.m_Instances, this.m_neighbours.size());
        int index = 0;
        this.m_Distances = new double[this.m_neighbours.size()];
        for (NewNNSearch.InstanceNode in : this.m_neighbours) {
            this.m_Distances[index++] = in.distance;
            neighbours.add(this.m_Instances.instance(in.instance_index));
        }
        this.m_DistanceFunction.postProcessDistances(this.m_Distances);
        if (this.m_Stats != null) {
            this.m_Stats.searchFinish();
        }
        return neighbours;
    }

    @Override
    public void setInstances(Instances insts) throws Exception {
        Instances t_instances;
        this.m_Instances = insts;
        this.m_myInstances = t_instances = this.transformInstances(insts);
        this.m_DistanceFunction.setInstances(t_instances);
    }

    @Override
    public void update(Instance ins) throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No instances supplied yet. Cannot update withoutsupplying a set of instances first.");
        }
        this.m_DistanceFunction.update(this.transformInstance(ins));
    }

    @Override
    public void addInstanceInfo(Instance ins) {
        if (this.m_Instances != null) {
            try {
                this.update(ins);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tFull class name of filter to use, followed\n\tby filter options.\n\teg: \"weka.filters.unsupervised.attribute.Remove -V -R 1,2\"", "F", 1, "-F <filter specification>"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        return result.elements();
    }

    public String filterTipText() {
        return "The filter to be used.";
    }

    public void setFilter(Filter filter) {
        this.m_Filter = filter;
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    protected String getFilterSpec() {
        Filter c = this.getFilter();
        if (c instanceof OptionHandler) {
            return c.getClass().getName() + " " + Utils.joinOptions((String[])c.getOptions());
        }
        return c.getClass().getName();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String filterString = Utils.getOption((char)'F', (String[])options);
        if (filterString.length() > 0) {
            String[] filterSpec = Utils.splitOptions((String)filterString);
            if (filterSpec.length == 0) {
                throw new IllegalArgumentException("Invalid filter specification string");
            }
            String filterName = filterSpec[0];
            filterSpec[0] = "";
            this.setFilter((Filter)Utils.forName(Filter.class, (String)filterName, (String[])filterSpec));
        } else {
            this.setFilter((Filter)new Discretize());
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 2];
        int current = 0;
        options[current++] = "-F";
        options[current++] = "" + this.getFilterSpec();
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        return options;
    }
}

