/*
 * Decompiled with CFR 0.152.
 */
package weka.core.tokenizers.cleaners;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Pattern;
import weka.core.Utils;
import weka.core.WekaOptionUtils;
import weka.core.tokenizers.cleaners.AbstractTokenCleaner;

public class RemoveNonWordCharTokens
extends AbstractTokenCleaner {
    private static final long serialVersionUID = -1815343837519097597L;
    public static final String PATTERN = ".*\\W.*";
    public static final String INVERT = "invert";
    protected boolean m_Invert = false;
    protected transient Pattern m_Pattern;

    @Override
    public String globalInfo() {
        return "Removes tokens that contain non-word characters: .*\\W.*\nMatching sense can be inverted, i.e., only tokens with non-word characters get returned.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, this.invertTipText(), "no", INVERT);
        WekaOptionUtils.add(result, super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setInvert(Utils.getFlag((String)INVERT, (String[])options));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, INVERT, this.getInvert());
        WekaOptionUtils.add(result, super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If enabled, the emoticons are the only tokens not removed.";
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Pattern = null;
    }

    @Override
    public String clean(String token) {
        if (this.m_Pattern == null) {
            this.m_Pattern = Pattern.compile(PATTERN);
        }
        if (this.m_Invert && !this.m_Pattern.matcher(token).matches()) {
            return null;
        }
        if (!this.m_Invert && this.m_Pattern.matcher(token).matches()) {
            return null;
        }
        return token;
    }
}

