/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import java.util.HashMap;
import java.util.Map;
import weka.core.Attribute;
import weka.core.Instance;

public class WekaInstanceToMap
extends AbstractConversion {
    private static final long serialVersionUID = 6188118988692631954L;

    public String globalInfo() {
        return "Turns the Weka Instance into a Map, with the attribute names the keys.";
    }

    public Class accepts() {
        return Instance.class;
    }

    public Class generates() {
        return Map.class;
    }

    protected Object doConvert() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Instance inst = (Instance)this.m_Input;
        block4: for (int i = 0; i < inst.numAttributes(); ++i) {
            Attribute att = inst.attribute(i);
            if (inst.isMissing(i)) {
                result.put(att.name(), null);
                continue;
            }
            switch (att.type()) {
                case 0: {
                    result.put(att.name(), inst.value(i));
                    continue block4;
                }
                case 1: 
                case 2: 
                case 3: {
                    result.put(att.name(), inst.stringValue(i));
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Unhandled attribute type at #" + (i + 1) + "/" + att.name() + ": " + Attribute.typeToString((int)att.type()));
                }
            }
        }
        return result;
    }
}

