/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instancesanalysis.pls;

import adams.core.TechnicalInformation;
import adams.data.instancesanalysis.pls.AbstractSingleClassPLS;
import adams.data.instancesanalysis.pls.MatrixHelper;
import adams.data.instancesanalysis.pls.PreprocessingType;
import com.github.waikatodatamining.matrix.core.Matrix;
import java.util.Map;
import weka.core.Instances;

public class SparsePLS
extends AbstractSingleClassPLS {
    private static final long serialVersionUID = -1605633160253194760L;
    protected com.github.waikatodatamining.matrix.algorithm.pls.SparsePLS m_SparsePLS;
    protected double m_Tol;
    protected int m_MaxIter;
    protected double m_Lambda;

    public String globalInfo() {
        return "Nonlinear Iterative Partial Least Squares (SparsePLS).\nAutomatically standardizes X and Y internally.\n\nFor more information see:\n" + this.getTechnicalInformation();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Chun H, Keles S.");
        result.setValue(TechnicalInformation.Field.YEAR, "2010");
        result.setValue(TechnicalInformation.Field.TITLE, "Sparse partial least squares regression for simultaneous dimension reduction and variable selection");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Royal Statistical Society Series B, Statistical Methodology");
        result.setValue(TechnicalInformation.Field.VOLUME, "1");
        result.setValue(TechnicalInformation.Field.PAGES, "3-25");
        result.setValue(TechnicalInformation.Field.URL, "https://www.ncbi.nlm.nih.gov/pmc/articles/PMC2810828/");
        return result;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("tol", "tol", (Object)1.0E-7, (Number)0.0, null);
        this.m_OptionManager.add("max-iter", "maxIter", (Object)500, (Number)1, null);
        this.m_OptionManager.add("lambda", "lambda", (Object)0.5, (Number)0.0, null);
    }

    @Override
    protected PreprocessingType getDefaultPreprocessingType() {
        return PreprocessingType.NONE;
    }

    public void setTol(double value) {
        if (this.getOptionManager().isValid("tol", (Number)value)) {
            this.m_Tol = value;
            this.reset();
        }
    }

    public double getTol() {
        return this.m_Tol;
    }

    public String tolTipText() {
        return "The inner NIPALS loop improvement tolerance.";
    }

    public void setMaxIter(int value) {
        if (this.getOptionManager().isValid("maxIter", (Number)value)) {
            this.m_MaxIter = value;
            this.reset();
        }
    }

    public int getMaxIter() {
        return this.m_MaxIter;
    }

    public String maxIterTipText() {
        return "The inner NIPALS loop maximum number of iterations.";
    }

    public void setLambda(double value) {
        if (this.getOptionManager().isValid("lambda", (Number)value)) {
            this.m_Lambda = value;
            this.reset();
        }
    }

    public double getLambda() {
        return this.m_Lambda;
    }

    public String lambdaTipText() {
        return "The sparsity parameter; determines sparseness.";
    }

    @Override
    public String[] getMatrixNames() {
        return this.m_SparsePLS.getMatrixNames();
    }

    @Override
    public weka.core.matrix.Matrix getMatrix(String name) {
        return MatrixHelper.matrixAlgoToWeka(this.m_SparsePLS.getMatrix(name));
    }

    @Override
    public boolean hasLoadings() {
        return this.m_SparsePLS.hasLoadings();
    }

    @Override
    public weka.core.matrix.Matrix getLoadings() {
        return MatrixHelper.matrixAlgoToWeka(this.m_SparsePLS.getLoadings());
    }

    @Override
    protected Instances doTransform(Instances data, Map<String, Object> params) throws Exception {
        Matrix X = MatrixHelper.wekaToMatrixAlgo(MatrixHelper.getX(data));
        Matrix y = MatrixHelper.wekaToMatrixAlgo(MatrixHelper.getY(data));
        if (!this.isInitialized()) {
            this.m_SparsePLS = new com.github.waikatodatamining.matrix.algorithm.pls.SparsePLS();
            this.m_SparsePLS.setNumComponents(this.m_NumComponents);
            this.m_SparsePLS.setPreprocessingType(com.github.waikatodatamining.matrix.core.PreprocessingType.NONE);
            this.m_SparsePLS.setTol(this.m_Tol);
            this.m_SparsePLS.setMaxIter(this.m_MaxIter);
            this.m_SparsePLS.setLambda(this.m_Lambda);
            String error = this.m_SparsePLS.initialize(X, y);
            if (error != null) {
                throw new Exception(error);
            }
        }
        Matrix X_new = this.m_SparsePLS.transform(X);
        return MatrixHelper.toInstances(this.getOutputFormat(), MatrixHelper.matrixAlgoToWeka(X_new), MatrixHelper.matrixAlgoToWeka(y));
    }
}

