/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka.rowfinder;

import adams.data.weka.rowfinder.AbstractRowFinder;
import adams.data.weka.rowfinder.TrainableRowFinder;
import weka.core.Instances;

public abstract class AbstractTrainableRowFinder
extends AbstractRowFinder
implements TrainableRowFinder {
    private static final long serialVersionUID = 3800769979430280486L;
    protected boolean m_Trained;

    protected void reset() {
        super.reset();
        this.m_Trained = false;
    }

    protected abstract boolean doTrainRowFinder(Instances var1);

    @Override
    public boolean trainRowFinder(Instances data) {
        this.m_Trained = this.doTrainRowFinder(data);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Training success: " + this.m_Trained);
        }
        return this.m_Trained;
    }

    @Override
    public boolean isRowFinderTrained() {
        return this.m_Trained;
    }

    @Override
    protected void check(Instances data) {
        super.check(data);
        if (!this.isRowFinderTrained() && !this.trainRowFinder(data)) {
            throw new IllegalStateException("Unable to train row finder!");
        }
    }
}

