/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka.rowfinder;

import adams.data.weka.WekaAttributeIndex;
import adams.data.weka.rowfinder.AbstractRowFinder;
import gnu.trove.list.array.TIntArrayList;
import weka.core.Instance;
import weka.core.Instances;

public class ByNumericValue
extends AbstractRowFinder {
    private static final long serialVersionUID = 235661615457187608L;
    public static final String NAN = "NaN";
    protected WekaAttributeIndex m_AttributeIndex;
    protected double m_Minimum;
    protected boolean m_MinimumIncluded;
    protected double m_Maximum;
    protected boolean m_MaximumIncluded;

    public String globalInfo() {
        return "Returns the indices of rows of columns which values fall inside the minimum and maximum.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("att-index", "attributeIndex", (Object)new WekaAttributeIndex("last"));
        this.m_OptionManager.add("minimum", "minimum", (Object)Double.NaN);
        this.m_OptionManager.add("minimum-included", "minimumIncluded", (Object)false);
        this.m_OptionManager.add("maximum", "maximum", (Object)Double.NaN);
        this.m_OptionManager.add("maximum-included", "maximumIncluded", (Object)false);
    }

    public void setAttributeIndex(WekaAttributeIndex value) {
        this.m_AttributeIndex = value;
        this.reset();
    }

    public WekaAttributeIndex getAttributeIndex() {
        return this.m_AttributeIndex;
    }

    public String attributeIndexTipText() {
        return "The index of the column to use for matching; " + this.m_AttributeIndex.getExample();
    }

    public void setMinimum(double value) {
        this.m_Minimum = value;
        this.reset();
    }

    public double getMinimum() {
        return this.m_Minimum;
    }

    public String minimumTipText() {
        return "The minimum value that the values must satisfy; use NaN (not a number) to ignore minimum.";
    }

    public void setMinimumIncluded(boolean value) {
        this.m_MinimumIncluded = value;
        this.reset();
    }

    public boolean getMinimumIncluded() {
        return this.m_MinimumIncluded;
    }

    public String minimumIncludedTipText() {
        return "If enabled, then the minimum value gets included (testing '<=' rather than '<').";
    }

    public void setMaximum(double value) {
        this.m_Maximum = value;
        this.reset();
    }

    public double getMaximum() {
        return this.m_Maximum;
    }

    public String maximumTipText() {
        return "The maximum value that the values must satisfy; use NaN (not a number) to ignore maximum.";
    }

    public void setMaximumIncluded(boolean value) {
        this.m_MaximumIncluded = value;
        this.reset();
    }

    public boolean getMaximumIncluded() {
        return this.m_MaximumIncluded;
    }

    public String maximumIncludedTipText() {
        return "If enabled, then the maximum value gets included (testing '>=' rather than '>').";
    }

    @Override
    protected int[] doFindRows(Instances data) {
        TIntArrayList result = new TIntArrayList();
        this.m_AttributeIndex.setData(data);
        int index = this.m_AttributeIndex.getIntIndex();
        if (index == -1) {
            throw new IllegalStateException("Invalid index '" + this.m_AttributeIndex.getIndex() + "'?");
        }
        if (!data.attribute(index).isNumeric()) {
            throw new IllegalStateException("Column at index '" + this.m_AttributeIndex.getIndex() + "' is not numeric!");
        }
        for (int i = 0; i < data.numInstances(); ++i) {
            Instance row = data.instance(i);
            if (row.isMissing(index)) continue;
            double value = row.value(index);
            boolean add = true;
            if (!Double.isNaN(this.m_Minimum)) {
                if (this.m_MinimumIncluded) {
                    if (value < this.m_Minimum) {
                        add = false;
                    }
                } else if (value <= this.m_Minimum) {
                    add = false;
                }
            }
            if (!Double.isNaN(this.m_Maximum)) {
                if (this.m_MaximumIncluded) {
                    if (value > this.m_Maximum) {
                        add = false;
                    }
                } else if (value >= this.m_Maximum) {
                    add = false;
                }
            }
            if (!add) continue;
            result.add(i);
        }
        return result.toArray();
    }
}

