/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.Shortening;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSourceWithPropertiesUpdating;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;

public class WekaClassifierSetup
extends AbstractSimpleSourceWithPropertiesUpdating {
    private static final long serialVersionUID = -3019442578354930841L;
    protected Classifier m_Classifier;

    public String globalInfo() {
        return "Outputs an instance of the specified classifier.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("classifier", "classifier", (Object)new ZeroR());
    }

    public void setClassifier(Classifier value) {
        this.m_Classifier = value;
        this.reset();
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "The Weka classifier to train on the input data.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        if (!result.isEmpty()) {
            result = result + ", ";
        }
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"classifier", (Object)Shortening.shortenEnd((String)OptionUtils.getShortCommandLine((Object)this.m_Classifier), (int)40));
        return result;
    }

    public Class[] generates() {
        return new Class[]{Classifier.class};
    }

    protected String doExecute() {
        String result;
        try {
            Classifier cls = (Classifier)OptionUtils.shallowCopy((Object)this.m_Classifier);
            result = this.setUpContainersIfNecessary(cls);
            if (result == null) {
                result = this.updateObject(cls);
            }
            if (result == null) {
                this.m_OutputToken = new Token((Object)cls);
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to create copy of classifier:", e);
        }
        return result;
    }
}

