/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.wekaclassifiersetupprocessor.AbstractClassifierSetupProcessor;
import adams.flow.transformer.wekaclassifiersetupprocessor.PassThrough;
import weka.classifiers.Classifier;

public class WekaClassifierSetupProcessor
extends AbstractTransformer {
    private static final long serialVersionUID = -3019442578354930841L;
    protected AbstractClassifierSetupProcessor m_Processor;

    public String globalInfo() {
        return "Applies the specified processor to the incoming array of classifiers, e.g., for generating new or filtered setups.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("processor", "processor", (Object)new PassThrough());
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"processor", (Object)((Object)this.m_Processor), (String)"processor: ");
    }

    public void setProcessor(AbstractClassifierSetupProcessor value) {
        this.m_Processor = value;
        this.reset();
    }

    public AbstractClassifierSetupProcessor getProcessor() {
        return this.m_Processor;
    }

    public String processorTipText() {
        return "The processor to apply to the incoming classifier arrays.";
    }

    public Class[] accepts() {
        return new Class[]{Classifier[].class};
    }

    public Class[] generates() {
        return new Class[]{Classifier[].class};
    }

    protected String doExecute() {
        String result = null;
        try {
            Classifier[] cls = (Classifier[])this.m_InputToken.getPayload();
            cls = this.m_Processor.process(cls);
            this.m_OutputToken = new Token((Object)cls);
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to process classifiers: ", e);
        }
        return result;
    }
}

