/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.WekaMergeInstancesActor;
import adams.flow.transformer.wekadatasetsmerge.AbstractMerge;
import adams.flow.transformer.wekadatasetsmerge.Simple;
import weka.core.Instance;
import weka.core.Instances;

public class WekaDatasetsMerge
extends AbstractTransformer
implements WekaMergeInstancesActor {
    private static final long serialVersionUID = 433833069085059906L;
    protected AbstractMerge m_MergeMethod;

    public String globalInfo() {
        return "Merges 2 or more datasets into a single dataset, using a selectable merge method.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("method", "mergeMethod", (Object)new Simple());
    }

    public AbstractMerge getMergeMethod() {
        return this.m_MergeMethod;
    }

    public void setMergeMethod(AbstractMerge mergeMethod) {
        this.m_MergeMethod = mergeMethod;
        this.reset();
    }

    public String mergeMethodTipText() {
        return "The method that should be used to perform the merge.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"mergeMethod", (Object)((Object)this.m_MergeMethod), (String)"method: ");
    }

    protected Instances[] getInput() {
        Instances[] datasets;
        Object payload = this.m_InputToken.getPayload();
        if (payload instanceof Instances[]) {
            datasets = (Instances[])payload;
        } else if (payload instanceof Instance[]) {
            Instance[] instancePayload = (Instance[])payload;
            datasets = new Instances[instancePayload.length];
            for (int i = 0; i < instancePayload.length; ++i) {
                datasets[i] = this.datasetForSingleInstance(instancePayload[i]);
            }
        } else {
            throw new IllegalStateException("Unhandled input type: " + this.m_InputToken.getPayload().getClass());
        }
        return datasets;
    }

    protected Instances datasetForSingleInstance(Instance instance) {
        Instances dataset = new Instances(instance.dataset(), 1);
        dataset.add((Instance)instance.copy());
        return dataset;
    }

    protected void setOutput(Instances output) {
        this.m_OutputToken = new Token();
        this.m_OutputToken.setPayload((Object)output);
    }

    protected String doExecute() {
        try {
            Instances[] datasetsToMerge = this.getInput();
            Instances joinedDataset = this.m_MergeMethod.merge(datasetsToMerge);
            this.setOutput(joinedDataset);
            return null;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public Class[] accepts() {
        return new Class[]{Instances[].class, Instance[].class};
    }

    public Class[] generates() {
        return new Class[]{Instances.class};
    }
}

