/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaModelContainer;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Token;
import adams.flow.source.WekaClassifierSetup;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Hashtable;
import weka.classifiers.Classifier;
import weka.classifiers.UpdateableClassifier;
import weka.core.Instance;
import weka.core.Instances;

public class WekaTrainClassifier
extends AbstractTransformer {
    private static final long serialVersionUID = -3019442578354930841L;
    public static final String BACKUP_INCREMENTALCLASSIFIER = "incremental classifier";
    protected CallableActorReference m_Classifier;
    protected Classifier m_IncrementalClassifier;
    protected boolean m_SkipBuild;

    public String globalInfo() {
        return "Trains a classifier based on the incoming dataset and outputs the built classifier alongside the training header (in a model container).\nIncremental training is performed, if the input are weka.core.Instance objects and the classifier implements " + UpdateableClassifier.class.getName() + ".";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("classifier", "classifier", (Object)new CallableActorReference(WekaClassifierSetup.class.getSimpleName()));
        this.m_OptionManager.add("skip-build", "skipBuild", (Object)false);
    }

    public void setClassifier(CallableActorReference value) {
        this.m_Classifier = value;
        this.reset();
    }

    public CallableActorReference getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "The Weka classifier to train on the input data.";
    }

    public void setSkipBuild(boolean value) {
        this.m_SkipBuild = value;
        this.reset();
    }

    public boolean getSkipBuild() {
        return this.m_SkipBuild;
    }

    public String skipBuildTipText() {
        return "If enabled, the buildClassifier call gets skipped in case of incremental classifiers, eg, if the model only needs updating after being loaded from disk.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"classifier", (Object)this.m_Classifier);
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"skipBuild", (boolean)this.m_SkipBuild, (String)"skip build"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_INCREMENTALCLASSIFIER);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_IncrementalClassifier != null) {
            result.put(BACKUP_INCREMENTALCLASSIFIER, this.m_IncrementalClassifier);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INCREMENTALCLASSIFIER)) {
            this.m_IncrementalClassifier = (Classifier)state.get(BACKUP_INCREMENTALCLASSIFIER);
            state.remove(BACKUP_INCREMENTALCLASSIFIER);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_IncrementalClassifier = null;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class, Instance.class};
    }

    public Class[] generates() {
        return new Class[]{WekaModelContainer.class};
    }

    protected Classifier getClassifierInstance() throws Exception {
        MessageCollection errors = new MessageCollection();
        Classifier result = (Classifier)CallableActorHelper.getSetup(Classifier.class, (CallableActorReference)this.m_Classifier, (Actor)this, (MessageCollection)errors);
        if (result == null) {
            if (errors.isEmpty()) {
                throw new IllegalStateException("Failed to obtain classifier from '" + this.m_Classifier + "'!");
            }
            throw new IllegalStateException("Failed to obtain classifier from '" + this.m_Classifier + "':\n" + errors);
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        try {
            Classifier cls = null;
            if (this.m_InputToken != null && this.m_InputToken.getPayload() instanceof Instances) {
                cls = this.getClassifierInstance();
                Instances data = (Instances)this.m_InputToken.getPayload();
                cls.buildClassifier(data);
                this.m_OutputToken = new Token((Object)new WekaModelContainer(cls, new Instances(data, 0), data));
            } else if (this.m_InputToken != null && this.m_InputToken.getPayload() instanceof Instance) {
                if (this.m_IncrementalClassifier == null && !((cls = this.getClassifierInstance()) instanceof UpdateableClassifier)) {
                    result = this.m_Classifier + "/" + cls.getClass().getName() + " is not an incremental classifier!";
                }
                if (result == null) {
                    Instance inst = (Instance)this.m_InputToken.getPayload();
                    if (this.m_IncrementalClassifier == null) {
                        this.m_IncrementalClassifier = cls;
                        if (this.m_SkipBuild) {
                            ((UpdateableClassifier)this.m_IncrementalClassifier).updateClassifier(inst);
                        } else {
                            Instances data = new Instances(inst.dataset(), 1);
                            data.add((Instance)inst.copy());
                            this.m_IncrementalClassifier.buildClassifier(data);
                        }
                    } else {
                        ((UpdateableClassifier)this.m_IncrementalClassifier).updateClassifier(inst);
                    }
                    this.m_OutputToken = new Token((Object)new WekaModelContainer(this.m_IncrementalClassifier, new Instances(inst.dataset(), 0)));
                }
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to process data:", e);
        }
        return result;
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_IncrementalClassifier = null;
    }
}

