/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.weka;

import adams.core.Properties;
import adams.core.logging.LoggingHelper;
import adams.core.option.OptionUtils;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.PropertiesParameterPanel;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.wizard.AbstractWizardPage;
import adams.gui.wizard.FinalPage;
import adams.gui.wizard.PageCheck;
import adams.gui.wizard.ParameterPanelPage;
import adams.gui.wizard.WekaSelectMultipleDatasetsPage;
import adams.gui.wizard.WizardPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.core.converters.Loader;
import weka.filters.AllFilter;
import weka.filters.Filter;

public class BatchFilterDatasetsPanel
extends BasePanel {
    private static final long serialVersionUID = -1965973872146968486L;
    protected WizardPane m_Wizard;
    protected boolean m_CloseParent;

    public BatchFilterDatasetsPanel(boolean closeParent) {
        this.m_CloseParent = closeParent;
    }

    protected void initGUI() {
        super.initGUI();
        AllFilter filter = new AllFilter();
        this.m_Wizard = new WizardPane();
        this.add((Component)this.m_Wizard, "Center");
        this.m_Wizard.setCustomFinishText("Filter");
        WekaSelectMultipleDatasetsPage infiles = new WekaSelectMultipleDatasetsPage("Input");
        infiles.setDescription("Select the Weka datasets to batch-filter.\nYou have to choose at least two.\nThe first dataset is used to set up the filter, all subsequent files get filtered with this set up.");
        infiles.setPageCheck(new PageCheck(){

            public boolean checkPage(AbstractWizardPage page) {
                Properties props = page.getProperties();
                try {
                    String[] files = OptionUtils.splitOptions((String)props.getProperty("files"));
                    return files.length >= 2;
                }
                catch (Exception e) {
                    ConsolePanel.getSingleton().append((Object)Level.SEVERE, "Failed to obtain files:", (Throwable)e);
                    return false;
                }
            }
        });
        this.m_Wizard.addPage((AbstractWizardPage)infiles);
        ParameterPanelPage paramsFilter = new ParameterPanelPage("Filter");
        paramsFilter.setDescription("Set up the filter that is used to filter the datasets.\nIf no class attribute is to be set, simply empty the 'Class' property. You can use 'first' and 'last' as well as 1-based indices.");
        paramsFilter.getParameterPanel().addPropertyType("Filter", PropertiesParameterPanel.PropertyType.OBJECT_EDITOR);
        paramsFilter.getParameterPanel().setChooser("Filter", (AbstractChooserPanel)new GenericObjectEditorPanel(Filter.class, (Object)filter, true));
        paramsFilter.getParameterPanel().addPropertyType("Class", PropertiesParameterPanel.PropertyType.STRING);
        paramsFilter.getParameterPanel().addPropertyType("Keep relation name", PropertiesParameterPanel.PropertyType.BOOLEAN);
        paramsFilter.getParameterPanel().setPropertyOrder(new String[]{"Filter", "Class", "Keep relation name"});
        Properties props = new Properties();
        props.setProperty("Filter", OptionUtils.getCommandLine((Object)filter));
        props.setProperty("Class", "last");
        props.setBoolean("Keep relation name", Boolean.valueOf(false));
        paramsFilter.getParameterPanel().setProperties(props);
        this.m_Wizard.addPage((AbstractWizardPage)paramsFilter);
        ParameterPanelPage paramsOutput = new ParameterPanelPage("Output");
        paramsOutput.setDescription("Select the directory where to place the generated datasets in ARFF format (the input file names get reused for the output).");
        paramsOutput.getParameterPanel().addPropertyType("Output", PropertiesParameterPanel.PropertyType.DIRECTORY_ABSOLUTE);
        props = new Properties();
        props.setPath("Output", ".");
        paramsOutput.getParameterPanel().setProperties(props);
        this.m_Wizard.addPage((AbstractWizardPage)paramsOutput);
        FinalPage finalpage = new FinalPage();
        finalpage.setLogo(null);
        finalpage.setDescription("<html><h2>Ready</h2>Please click on <b>Filter</b> to start the process.</html>");
        this.m_Wizard.addPage((AbstractWizardPage)finalpage);
        this.m_Wizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!e.getActionCommand().equals("Finish")) {
                    if (BatchFilterDatasetsPanel.this.m_CloseParent) {
                        BatchFilterDatasetsPanel.this.closeParent();
                    }
                    return;
                }
                Properties props = BatchFilterDatasetsPanel.this.m_Wizard.getProperties(false);
                String[] files = null;
                Filter filter = null;
                String classIndex = null;
                File outdir = null;
                boolean keep = false;
                try {
                    files = OptionUtils.splitOptions((String)props.getProperty("files"));
                    filter = (Filter)OptionUtils.forAnyCommandLine(Filter.class, (String)props.getProperty("Filter"));
                    classIndex = props.getProperty("Class");
                    outdir = new File(props.getPath("Output"));
                    keep = props.getBoolean("Keep relation name");
                }
                catch (Exception ex) {
                    GUIHelper.showErrorMessage((Component)BatchFilterDatasetsPanel.this.getParent(), (String)("Failed to get setup from wizard!\n" + LoggingHelper.throwableToString((Throwable)ex)));
                    return;
                }
                BatchFilterDatasetsPanel.this.batchFilter(files, filter, classIndex, keep, outdir);
            }
        });
    }

    protected void batchFilter(String[] input, Filter filter, String classIndex, boolean keep, File outdir) {
        int clsIndex;
        int i;
        if (input.length < 2) {
            GUIHelper.showErrorMessage((Component)this.getParent(), (String)"At least two files are required!");
            return;
        }
        AbstractFileLoader loader = ConverterUtils.getLoaderForFile((String)input[0]);
        Instances[] data = new Instances[input.length];
        for (i = 0; i < input.length; ++i) {
            try {
                loader.setFile(new File(input[i]));
                data[i] = ConverterUtils.DataSource.read((Loader)loader);
                continue;
            }
            catch (Exception e) {
                GUIHelper.showErrorMessage((Component)this.getParent(), (String)("Failed to read '" + input[i] + "'!\n" + LoggingHelper.throwableToString((Throwable)e)));
                return;
            }
        }
        if (classIndex.isEmpty()) {
            clsIndex = -1;
        } else {
            try {
                clsIndex = classIndex.equalsIgnoreCase("first") ? 0 : (classIndex.equalsIgnoreCase("last") ? data[0].numAttributes() - 1 : Integer.parseInt(classIndex) - 1);
            }
            catch (Exception e) {
                GUIHelper.showErrorMessage((Component)this.getParent(), (String)("Failed to parse class attribute index: " + classIndex + "\n" + LoggingHelper.throwableToString((Throwable)e)));
                return;
            }
        }
        StringBuilder outfiles = new StringBuilder();
        for (i = 0; i < input.length; ++i) {
            try {
                String outfile = outdir.getAbsolutePath() + File.separator + new File(input[i]).getName();
                data[i].setClassIndex(clsIndex);
                if (i == 0) {
                    filter.setInputFormat(data[i]);
                }
                Instances filtered = Filter.useFilter((Instances)data[i], (Filter)filter);
                if (keep) {
                    filtered.setRelationName(data[i].relationName());
                }
                ConverterUtils.DataSink.write((String)outfile, (Instances)filtered);
                if (outfiles.length() > 0) {
                    outfiles.append("\n");
                }
                outfiles.append(outfile);
                continue;
            }
            catch (Exception e) {
                GUIHelper.showErrorMessage((Component)this.getParent(), (String)("Failed to filter dataset #" + (i + 1) + " ('" + input[i] + "')!\n" + LoggingHelper.throwableToString((Throwable)e)));
                return;
            }
        }
        GUIHelper.showInformationMessage(null, (String)("Successfully filtered!\n" + outfiles));
        if (this.m_CloseParent) {
            this.closeParent();
        }
    }
}

