/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.datatable;

import adams.gui.core.AbstractMoveableTableModel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import weka.core.Attribute;

public class DataTableModel
extends AbstractMoveableTableModel {
    private static final long serialVersionUID = 8586181476263855804L;
    protected List<DataContainer> m_Data;
    protected boolean m_ReadOnly;

    public DataTableModel(List<DataContainer> data, boolean readOnly) {
        this.m_Data = new ArrayList<DataContainer>(data);
        this.m_ReadOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.m_ReadOnly;
    }

    public int getRowCount() {
        return this.m_Data.size();
    }

    public int getColumnCount() {
        int result = 0;
        ++result;
        ++result;
        ++result;
        ++result;
        return ++result;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "ID";
            }
            case 1: {
                return "Mod";
            }
            case 2: {
                return "Relation";
            }
            case 3: {
                return "Class";
            }
            case 4: {
                return "Source";
            }
        }
        return null;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        DataContainer cont = this.m_Data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return cont.getID();
            }
            case 1: {
                return cont.isModified();
            }
            case 2: {
                return cont.getData().relationName();
            }
            case 3: {
                return cont.getData().classIndex() == -1 ? "<none>" : cont.getData().classAttribute().name();
            }
            case 4: {
                return cont.getSource();
            }
        }
        return null;
    }

    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Integer.class;
        }
        if (columnIndex == 1) {
            return Boolean.class;
        }
        return super.getColumnClass(columnIndex);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.m_ReadOnly) {
            return false;
        }
        return columnIndex == 3;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.m_ReadOnly) {
            return;
        }
        if (aValue == null) {
            return;
        }
        DataContainer cont = this.m_Data.get(rowIndex);
        switch (columnIndex) {
            case 3: {
                String name = "" + aValue;
                if (name.isEmpty()) {
                    cont.addUndoPoint("Unsetting class");
                    cont.getData().setClassIndex(-1);
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                    break;
                }
                Attribute att = cont.getData().attribute(name);
                if (att == null) break;
                cont.addUndoPoint("Setting class");
                cont.getData().setClassIndex(att.index());
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }
        }
    }

    public void setData(List<DataContainer> value) {
        this.setData(value, true);
    }

    public void setData(List<DataContainer> value, boolean notify) {
        this.m_Data = new ArrayList<DataContainer>(value);
        if (notify) {
            this.fireTableDataChanged();
        }
    }

    public List<DataContainer> getData() {
        return this.m_Data;
    }

    protected void swap(int firstIndex, int secondIndex) {
        Collections.swap(this.m_Data, firstIndex, secondIndex);
    }
}

