/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.datatable.action;

import adams.gui.core.GUIHelper;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.datatable.action.AbstractEditableDataTableAction;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class Rename
extends AbstractEditableDataTableAction {
    private static final long serialVersionUID = -8374323161691034031L;

    public Rename() {
        this.setName("Rename");
        this.setIcon("rename.png");
    }

    protected void doActionPerformed(ActionEvent e) {
        DataContainer cont = this.getSelectedData()[0];
        this.logMessage("Renaming dataset: " + cont.getID() + "/" + cont.getData().relationName() + " [" + cont.getSource() + "]");
        String newName = GUIHelper.showInputDialog((Component)((Object)this.getOwner()), (String)"Please enter new relation name: ", (String)cont.getData().relationName());
        if (newName == null) {
            this.logMessage("Renaming cancelled!");
            return;
        }
        cont.addUndoPoint("renaming");
        cont.getData().setRelationName(newName);
        cont.setModified(true);
        this.logMessage("Successfully renamed " + cont.getID() + ": " + newName);
        this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner().getOwner(), 4, this.getSelectedRows()[0]));
    }

    @Override
    public void update() {
        this.setEnabled(!this.isBusy() && this.getTable().getSelectedRowCount() == 1);
    }
}

