/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.source;

import adams.core.Utils;
import adams.data.io.input.SpreadSheetReader;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.tools.wekainvestigator.data.SpreadSheetContainer;
import adams.gui.tools.wekainvestigator.job.InvestigatorJob;
import adams.gui.tools.wekainvestigator.source.AbstractSource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;

public class SpreadSheet
extends AbstractSource {
    private static final long serialVersionUID = 5646388990155938153L;
    protected SpreadSheetFileChooser m_FileChooser;

    public SpreadSheet() {
        this.setName("SpreadSheet...");
        this.setIcon("spreadsheet.png");
    }

    protected void doActionPerformed(ActionEvent e) {
        int retVal;
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new SpreadSheetFileChooser();
            this.m_FileChooser.setMultiSelectionEnabled(true);
        }
        if ((retVal = this.m_FileChooser.showOpenDialog((Component)((Object)this.m_Owner))) != 0) {
            return;
        }
        final SpreadSheetReader reader = (SpreadSheetReader)this.m_FileChooser.getReader();
        adams.data.spreadsheet.SpreadSheet sheet = reader.read(this.m_FileChooser.getSelectedFile());
        if (sheet == null) {
            this.logError("Failed to load spreadsheet: " + this.m_FileChooser.getSelectedFile(), "Error reading");
            return;
        }
        final File[] files = this.m_FileChooser.getSelectedFiles();
        InvestigatorJob job = new InvestigatorJob(this.getOwner(), "Loading file(s): " + Utils.arrayToString((Object)files)){

            @Override
            protected void doRun() {
                for (File file : files) {
                    SpreadSheet.this.addData(new SpreadSheetContainer(reader, file));
                }
            }
        };
        this.getOwner().startExecution(job);
    }
}

