/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab;

import adams.core.MessageCollection;
import adams.core.Range;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.BaseTableWithButtons;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.InvestigatorPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.datatable.DataTableModel;
import adams.gui.tools.wekainvestigator.datatable.DataTableWithButtons;
import adams.gui.tools.wekainvestigator.datatable.action.Rename;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTabWithEditableDataTable;
import com.googlecode.jfilechooserbookmarks.gui.BaseScrollPane;
import gnu.trove.list.array.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public abstract class AbstractInvestigatorTabWithDataTable
extends AbstractInvestigatorTab
implements TableModelListener {
    private static final long serialVersionUID = -94945456385486233L;
    public static final String KEY_DATATABLE_SELECTEDROWS = "datatable.selectedrows";
    public static final String KEY_DATATABLE_HEIGHT = "datatable.height";
    protected DataTableModel m_Model;
    protected DataTableWithButtons m_Table;
    protected JPanel m_PanelData;
    protected BaseSplitPane m_SplitPane;
    protected int m_DefaultDataTableHeight;
    protected boolean m_FirstAdd;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_DefaultDataTableHeight = InvestigatorPanel.getProperties().getInteger("General.DefaultDataTableHeight", Integer.valueOf(150));
        this.m_FirstAdd = true;
    }

    protected void initGUI() {
        super.initGUI();
        this.m_ContentPanel.setLayout((LayoutManager)new BorderLayout());
        this.m_SplitPane = new BaseSplitPane(0);
        this.m_SplitPane.setOneTouchExpandable(true);
        this.m_ContentPanel.add((Component)this.m_SplitPane, (Object)"Center");
        this.m_Model = new DataTableModel(new ArrayList<DataContainer>(), this.hasReadOnlyTable());
        this.m_Model.addTableModelListener(this);
        this.m_Table = new DataTableWithButtons(this.m_Model);
        this.m_Table.setPreferredSize(new Dimension(200, this.m_DefaultDataTableHeight));
        this.m_Table.setAutoResizeMode(0);
        this.m_Table.setSelectionMode(this.getDataTableListSelectionMode());
        this.m_Table.getSelectionModel().addListSelectionListener(e -> this.dataTableSelectionChanged());
        this.m_Table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    AbstractInvestigatorTabWithDataTable.this.removeData(AbstractInvestigatorTabWithDataTable.this.m_Table.getSelectedRows());
                    e.consume();
                } else if (e.getKeyCode() == 113) {
                    AbstractInvestigatorTabWithDataTable.this.renameData(AbstractInvestigatorTabWithDataTable.this.m_Table.getSelectedRows());
                    e.consume();
                }
                super.keyPressed(e);
            }
        });
        this.m_SplitPane.setTopComponent((Component)new BaseScrollPane((Component)((Object)this.m_Table)));
        this.m_SplitPane.setTopComponentHidden(false);
        this.m_PanelData = new JPanel(new BorderLayout());
        this.m_SplitPane.setBottomComponent((Component)this.m_PanelData);
        this.m_SplitPane.setBottomComponentHidden(true);
    }

    protected void finishInit() {
        super.finishInit();
        this.m_SplitPane.setDividerLocation(this.m_DefaultDataTableHeight + 20);
    }

    protected abstract boolean hasReadOnlyTable();

    protected abstract int getDataTableListSelectionMode();

    protected abstract void dataTableSelectionChanged();

    public BaseTableWithButtons getTable() {
        return this.m_Table;
    }

    protected DataContainer[] backupSelection() {
        ArrayList<DataContainer> result = new ArrayList<DataContainer>();
        for (int row : this.getSelectedRows()) {
            result.add(this.m_Model.getData().get(row));
        }
        return result.toArray(new DataContainer[result.size()]);
    }

    protected void restoreSelection(DataContainer[] conts) {
        this.m_Table.getSelectionModel().clearSelection();
        block0: for (DataContainer oldCont : conts) {
            for (int newIndex = 0; newIndex < this.m_Model.getData().size(); ++newIndex) {
                if (!oldCont.equals(this.m_Model.getData().get(newIndex))) continue;
                this.m_Table.getSelectionModel().addSelectionInterval(newIndex, newIndex);
                continue block0;
            }
        }
    }

    @Override
    public void dataChanged(WekaInvestigatorDataEvent e) {
        DataContainer[] backup = this.backupSelection();
        switch (e.getType()) {
            case 3: 
            case 4: {
                this.m_Model.removeTableModelListener(this);
                this.m_Model.setData(this.getData(), true);
                this.m_Model.addTableModelListener(this);
                this.restoreSelection(backup);
                break;
            }
            case 5: {
                if (this.m_Table.getSelectedRow() == -1 || e.getRows() == null || e.getRows().length <= 0) break;
                this.m_Table.setSelectedRow(e.getRows()[0]);
                break;
            }
            case 101: 
            case 102: {
                break;
            }
            case 103: 
            case 104: {
                this.m_Table.setSortAttributes(e.getType() == 103);
                break;
            }
            default: {
                this.m_Model.removeTableModelListener(this);
                this.m_Model = new DataTableModel(this.getOwner().getData(), this.hasReadOnlyTable());
                this.m_Model.addTableModelListener(this);
                int[] widths = this.m_Table.getColumnWidths();
                this.m_Table.setModel((TableModel)((Object)this.m_Model));
                if (e.getType() == 2 && e.getRows().length == this.getOwner().getData().size() && this.m_FirstAdd) {
                    this.m_Table.setOptimalColumnWidthBounded(300);
                    this.m_FirstAdd = false;
                } else {
                    this.m_Table.setColumnWidths(widths);
                }
                this.restoreSelection(backup);
            }
        }
    }

    protected int[] getSelectedRows() {
        return this.m_Table.getSelectedRows();
    }

    protected void activate(final int row) {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                AbstractInvestigatorTabWithDataTable.this.fireDataChange(new WekaInvestigatorDataEvent(AbstractInvestigatorTabWithDataTable.this.getOwner(), 5, row));
                return null;
            }
        };
        worker.execute();
    }

    protected void removeData(int[] rows) {
        if (this.hasReadOnlyTable()) {
            return;
        }
        ArrayList<DataContainer> list = new ArrayList<DataContainer>();
        if (rows == null) {
            list.addAll(this.getData());
            this.getData().clear();
            this.m_Model.fireTableDataChanged();
            this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner()));
        } else {
            Arrays.sort(rows);
            for (int i = rows.length - 1; i >= 0; --i) {
                this.logMessage("Removing: " + this.getData().get(i).getSource());
                DataContainer cont = this.getData().remove(rows[i]);
                list.add(cont);
            }
            this.m_Model.fireTableDataChanged();
            this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner(), 3, rows));
        }
        for (DataContainer c : list) {
            c.cleanUp();
        }
    }

    protected void renameData(int[] rows) {
        if (this.hasReadOnlyTable()) {
            return;
        }
        if (!(this instanceof AbstractInvestigatorTabWithEditableDataTable)) {
            return;
        }
        if (rows.length != 1) {
            return;
        }
        Rename rename = new Rename();
        rename.setOwner((AbstractInvestigatorTabWithEditableDataTable)this);
        rename.actionPerformed(new ActionEvent(this, 1, ""));
    }

    protected void undo(int[] rows) {
        if (this.hasReadOnlyTable()) {
            return;
        }
        TIntArrayList updated = new TIntArrayList();
        for (int i = 0; i < rows.length; ++i) {
            DataContainer cont = this.getData().get(rows[i]);
            if (!cont.isUndoSupported() || !cont.getUndo().canUndo()) continue;
            cont.getUndo().undo();
            updated.add(rows[i]);
        }
        if (updated.size() > 0) {
            this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner(), 4, updated.toArray()));
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        switch (e.getType()) {
            case -1: {
                Range range = new Range(e.getFirstRow() + 1 + "-" + e.getLastRow());
                range.setMax(e.getLastRow() + 1);
                this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner(), 3, range.getIntIndices()));
                break;
            }
            case 1: {
                Range range = new Range(e.getFirstRow() + 1 + "-" + e.getLastRow());
                range.setMax(e.getLastRow() + 1);
                this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner(), 2, range.getIntIndices()));
                break;
            }
            case 0: {
                Range range = new Range(e.getFirstRow() + 1 + "-" + e.getLastRow());
                range.setMax(e.getLastRow() + 1);
                this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner(), 4, range.getIntIndices()));
                break;
            }
            default: {
                this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner(), 1, null));
            }
        }
    }

    @Override
    protected Map<String, Object> doSerialize(Set<AbstractInvestigatorTab.SerializationOption> options) {
        Map<String, Object> result = super.doSerialize(options);
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.GUI)) {
            result.put(KEY_DATATABLE_SELECTEDROWS, this.m_Table.getSelectedRows());
            result.put(KEY_DATATABLE_HEIGHT, this.m_SplitPane.getDividerLocation());
        }
        return result;
    }

    @Override
    protected void doDeserialize(Map<String, Object> data, MessageCollection errors) {
        super.doDeserialize(data, errors);
        if (data.containsKey(KEY_DATATABLE_SELECTEDROWS)) {
            this.m_Table.setSelectedRows((int[])data.get(KEY_DATATABLE_SELECTEDROWS));
        }
        if (data.containsKey(KEY_DATATABLE_HEIGHT)) {
            this.m_SplitPane.setDividerLocation(((Integer)data.get(KEY_DATATABLE_HEIGHT)).intValue());
        }
    }
}

