/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.output;

import adams.core.MessageCollection;
import adams.core.Utils;
import adams.data.image.BooleanArrayMatrixView;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.container.PredictionEccentricityContainer;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.core.Token;
import adams.flow.transformer.PredictionEccentricity;
import adams.flow.transformer.WekaPredictionsToSpreadSheet;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.tools.wekainvestigator.output.ComponentContentPanel;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.output.AbstractOutputGeneratorWithSeparateFoldsSupport;
import adams.gui.visualization.image.ImagePanel;
import java.awt.Component;
import javax.swing.JComponent;
import weka.classifiers.Evaluation;

public class PredictionEccentricity
extends AbstractOutputGeneratorWithSeparateFoldsSupport<ComponentContentPanel> {
    private static final long serialVersionUID = -6829245659118360739L;
    protected int m_Grid;
    protected PredictionEccentricity.Morphology[] m_Morphologies;
    protected int m_NumCycles;

    public String globalInfo() {
        return "Generates classifier prediction eccentricity.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("grid", "grid", (Object)100, (Number)1, null);
        this.m_OptionManager.add("morphology", "morphologies", (Object)new PredictionEccentricity.Morphology[]{PredictionEccentricity.Morphology.DILATE});
        this.m_OptionManager.add("num-cycles", "numCycles", (Object)1, (Number)0, null);
    }

    public void setGrid(int value) {
        if (this.getOptionManager().isValid("grid", (Number)value)) {
            this.m_Grid = value;
            this.reset();
        }
    }

    public int getGrid() {
        return this.m_Grid;
    }

    public String gridTipText() {
        return "The size of the grid to project the predictions onto.";
    }

    public void setMorphologies(PredictionEccentricity.Morphology[] value) {
        this.m_Morphologies = value;
        this.reset();
    }

    public PredictionEccentricity.Morphology[] getMorphologies() {
        return this.m_Morphologies;
    }

    public String morphologiesTipText() {
        return "The morphologies to apply.";
    }

    public void setNumCycles(int value) {
        if (this.getOptionManager().isValid("numCycles", (Number)value)) {
            this.m_NumCycles = value;
            this.reset();
        }
    }

    public int getNumCycles() {
        return this.m_NumCycles;
    }

    public String numCyclesTipText() {
        return "The number of cycles to apply.";
    }

    @Override
    public String getTitle() {
        return "Prediction eccentricity";
    }

    @Override
    public boolean canGenerateOutput(ResultItem item) {
        return item.hasEvaluation() && item.getEvaluation().predictions() != null && item.getEvaluation().getHeader().classAttribute().isNumeric();
    }

    @Override
    protected ComponentContentPanel createOutput(Evaluation eval, MessageCollection errors) {
        WekaEvaluationContainer cont = new WekaEvaluationContainer(eval);
        WekaPredictionsToSpreadSheet p2s = new WekaPredictionsToSpreadSheet();
        p2s.input(new Token((Object)cont));
        try {
            p2s.execute();
        }
        catch (Exception e) {
            errors.add("Failed to assemble predictions!", (Throwable)e);
            return null;
        }
        Token token = p2s.output();
        adams.flow.transformer.PredictionEccentricity trans = new adams.flow.transformer.PredictionEccentricity();
        trans.setGrid(this.m_Grid);
        trans.setMorphologies(this.m_Morphologies);
        trans.setNumCycles(this.m_NumCycles);
        trans.setActual(new SpreadSheetColumnIndex("Actual"));
        trans.setPredicted(new SpreadSheetColumnIndex("Predicted"));
        trans.input(token);
        String msg = trans.execute();
        if (msg != null) {
            errors.add(msg);
            return null;
        }
        token = trans.output();
        PredictionEccentricityContainer eccCont = (PredictionEccentricityContainer)token.getPayload();
        if (!eccCont.hasValue("Eccentricity")) {
            errors.add("No eccentricity calculated!");
            return null;
        }
        double ecc = (Double)eccCont.getValue("Eccentricity");
        if (!eccCont.hasValue("Matrix")) {
            errors.add("No matrix generated!");
            return null;
        }
        BooleanArrayMatrixView matrix = (BooleanArrayMatrixView)eccCont.getValue("Matrix");
        DefaultSpreadSheet runInfo = new DefaultSpreadSheet();
        runInfo.getHeaderRow().addCell("K").setContentAsString("Key");
        runInfo.getHeaderRow().addCell("V").setContentAsString("Value");
        DataRow row = runInfo.addRow();
        row.addCell("K").setContentAsString("Eccentricity (1 - Inf)");
        row.addCell("V").setContent(Double.valueOf(ecc));
        row = runInfo.addRow();
        row.addCell("K").setContentAsString("Grid");
        row.addCell("V").setContent(Integer.valueOf(this.m_Grid));
        row = runInfo.addRow();
        row.addCell("K").setContentAsString("Morphologies");
        row.addCell("V").setContent(Utils.arrayToString((Object)this.m_Morphologies));
        row = runInfo.addRow();
        row.addCell("K").setContentAsString("# Cycles");
        row.addCell("V").setContent(Integer.valueOf(this.m_NumCycles));
        BaseSplitPane panel = new BaseSplitPane(0);
        SpreadSheetTableModel infoModel = new SpreadSheetTableModel((SpreadSheet)runInfo);
        infoModel.setUseSimpleHeader(true);
        infoModel.setShowRowColumn(false);
        infoModel.setReadOnly(true);
        infoModel.setNumDecimals(2);
        SpreadSheetTable infoTable = new SpreadSheetTable(infoModel);
        infoTable.setShowSimplePopupMenus(true);
        ImagePanel imagePanel = new ImagePanel();
        imagePanel.setCurrentImage(matrix.toBufferedImage());
        imagePanel.setScale(-1.0);
        panel.setBottomComponent((Component)imagePanel);
        panel.setTopComponent((Component)new BaseScrollPane((Component)infoTable));
        panel.setDividerLocation(100);
        return new ComponentContentPanel((JComponent)panel, false);
    }
}

