/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.clustertab.evaluation;

import adams.core.MessageCollection;
import adams.core.SerializationHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.MetaData;
import adams.gui.chooser.FileChooserPanel;
import adams.gui.core.BaseComboBox;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.ParameterPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.evaluation.DatasetHelper;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.tools.wekainvestigator.tab.ClusterTab;
import adams.gui.tools.wekainvestigator.tab.clustertab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.clustertab.evaluation.AbstractClustererEvaluation;
import java.awt.Component;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.filechooser.FileFilter;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.core.Capabilities;
import weka.core.Instances;

public class ReevaluateModel
extends AbstractClustererEvaluation {
    private static final long serialVersionUID = 1175400993991698944L;
    public static final String KEY_DATASET = "dataset";
    public static final String KEY_MODEL = "model";
    protected ParameterPanel m_PanelParameters;
    protected BaseComboBox<String> m_ComboBoxDatasets;
    protected DefaultComboBoxModel<String> m_ModelDatasets;
    protected FileChooserPanel m_PanelModel;
    protected Clusterer m_Model;
    protected Instances m_Header;

    public String globalInfo() {
        return "Re-evaluates a serialized clusterer on a test set.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Model = null;
        this.m_Header = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_PanelParameters = new ParameterPanel();
        this.m_PanelOptions.add((Component)this.m_PanelParameters, "Center");
        this.m_ModelDatasets = new DefaultComboBoxModel();
        this.m_ComboBoxDatasets = new BaseComboBox(this.m_ModelDatasets);
        this.m_ComboBoxDatasets.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Dataset", this.m_ComboBoxDatasets);
        this.m_PanelModel = new FileChooserPanel();
        ExtensionFileFilter filter = ExtensionFileFilter.getModelFileFilter();
        this.m_PanelModel.addChoosableFileFilter((FileFilter)filter);
        this.m_PanelModel.setFileFilter((FileFilter)filter);
        this.m_PanelModel.setAcceptAllFileFilterUsed(true);
        this.m_PanelModel.addChangeListener(e -> {
            this.m_Model = null;
            ((ClusterTab)this.getOwner()).updateButtons();
        });
        this.m_PanelParameters.addParameter("Model", (Component)this.m_PanelModel);
    }

    @Override
    public String getName() {
        return "Re-evaluate model";
    }

    protected String loadModel() {
        this.m_Model = null;
        this.m_Header = null;
        File file = (File)this.m_PanelModel.getCurrent();
        if (file.isDirectory()) {
            return "Model points to a directory: " + file;
        }
        if (!file.exists()) {
            return "Model does not exist: " + file;
        }
        if (!SerializationHelper.isSerializedObject((String)file.getAbsolutePath())) {
            return "Model file is not a serialized object: " + file;
        }
        try {
            Object[] obj = SerializationHelper.readAll((String)file.getAbsolutePath());
            if (obj.length > 0) {
                this.m_Model = (Clusterer)obj[0];
            }
            if (obj.length > 1) {
                this.m_Header = (Instances)obj[1];
            }
        }
        catch (Exception e) {
            return "Failed to load model: " + file + "\n" + e;
        }
        return null;
    }

    @Override
    public String canEvaluate(Clusterer clusterer) {
        String msg;
        if (!this.isValidDataIndex(this.m_ComboBoxDatasets)) {
            return "No data available!";
        }
        File file = (File)this.m_PanelModel.getCurrent();
        if (file.isDirectory()) {
            return "Model points to directory: " + file;
        }
        if (!file.exists()) {
            return "Model does not exist: " + file;
        }
        if (this.m_Model == null && (msg = this.loadModel()) != null) {
            return msg;
        }
        if (this.m_Model == null) {
            return "Failed to load model: " + file;
        }
        Instances data = ((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        if (this.m_Header != null && !data.equalHeaders(this.m_Header)) {
            return data.equalHeadersMsg(this.m_Header);
        }
        Capabilities caps = this.m_Model.getCapabilities();
        try {
            if (!caps.test(data)) {
                if (caps.getFailReason() != null) {
                    return caps.getFailReason().getMessage();
                }
                return "Clusterer cannot handle data!";
            }
        }
        catch (Exception e) {
            return "Clusterer cannot handle data: " + e;
        }
        return null;
    }

    @Override
    public ResultItem init(Clusterer clusterer) throws Exception {
        Instances data = ((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        ResultItem result = new ResultItem(clusterer, new Instances(data, 0));
        return result;
    }

    @Override
    protected void doEvaluate(Clusterer clusterer, ResultItem item) throws Exception {
        clusterer = (Clusterer)OptionUtils.shallowCopy((Object)this.m_Model);
        String msg = this.canEvaluate(clusterer);
        if (msg != null) {
            throw new IllegalArgumentException("Cannot evaluate clusterer!\n" + msg);
        }
        DataContainer dataCont = ((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex());
        Instances data = dataCont.getData();
        MetaData runInfo = new MetaData();
        runInfo.add("Clusterer", (Object)OptionUtils.getCommandLine((Object)clusterer));
        runInfo.add("Dataset ID", (Object)dataCont.getID());
        runInfo.add("Relation", (Object)data.relationName());
        runInfo.add("# Attributes", (Object)data.numAttributes());
        runInfo.add("# Instances", (Object)data.numInstances());
        this.addObjectSize(runInfo, "Model size", this.m_Model);
        ClusterEvaluation eval = new ClusterEvaluation();
        eval.setClusterer(this.m_Model);
        eval.evaluateClusterer(data);
        item.update(eval, this.m_Model, runInfo);
    }

    @Override
    public void update() {
        if (this.getOwner() == null) {
            return;
        }
        if (((ClusterTab)this.getOwner()).getOwner() == null) {
            return;
        }
        List<String> datasets = DatasetHelper.generateDatasetList(((ClusterTab)this.getOwner()).getData());
        int index = DatasetHelper.indexOfDataset(((ClusterTab)this.getOwner()).getData(), (String)this.m_ComboBoxDatasets.getSelectedItem());
        if (DatasetHelper.hasDataChanged(datasets, this.m_ModelDatasets)) {
            this.m_ModelDatasets = new DefaultComboBoxModel<String>(datasets.toArray(new String[datasets.size()]));
            this.m_ComboBoxDatasets.setModel(this.m_ModelDatasets);
            if (index == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxDatasets.setSelectedIndex(0);
            } else if (index > -1) {
                this.m_ComboBoxDatasets.setSelectedIndex(index);
            }
        }
        ((ClusterTab)this.getOwner()).updateButtons();
    }

    @Override
    public void activate(int index) {
        this.m_ComboBoxDatasets.setSelectedIndex(index);
    }

    @Override
    public Map<String, Object> serialize(Set<AbstractInvestigatorTab.SerializationOption> options) {
        Map<String, Object> result = super.serialize(options);
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.GUI)) {
            result.put(KEY_DATASET, this.m_ComboBoxDatasets.getSelectedIndex());
        }
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.PARAMETERS)) {
            result.put(KEY_MODEL, ((File)this.m_PanelModel.getCurrent()).getAbsolutePath());
        }
        return result;
    }

    @Override
    public void deserialize(Map<String, Object> data, MessageCollection errors) {
        super.deserialize(data, errors);
        if (data.containsKey(KEY_DATASET)) {
            this.m_ComboBoxDatasets.setSelectedIndex(((Number)data.get(KEY_DATASET)).intValue());
        }
        if (data.containsKey(KEY_MODEL)) {
            this.m_PanelModel.setCurrent((File)new PlaceholderFile((String)data.get(KEY_MODEL)));
        }
    }
}

