/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter;

import adams.core.ObjectCopyHelper;
import adams.gui.core.BaseComboBox;
import adams.gui.core.GUIHelper;
import adams.gui.tools.wekamultiexperimenter.AbstractExperimenterPanel;
import adams.gui.tools.wekamultiexperimenter.ExperimenterPanel;
import adams.gui.tools.wekamultiexperimenter.analysis.AbstractAnalysisPanel;
import adams.gui.tools.wekamultiexperimenter.analysis.DefaultAnalysisPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.core.Instances;

public class AnalysisPanel
extends AbstractExperimenterPanel {
    private static final long serialVersionUID = -7809897225003422111L;
    protected AbstractAnalysisPanel m_PanelAnalysis;
    protected BaseComboBox<AbstractAnalysisPanel> m_ComboBoxPanels;

    protected void initGUI() {
        super.initGUI();
        Class[] classes = AbstractAnalysisPanel.getPanels();
        ArrayList<AbstractAnalysisPanel> panels = new ArrayList<AbstractAnalysisPanel>();
        for (int i = 0; i < classes.length; ++i) {
            try {
                if (classes[i].equals(DefaultAnalysisPanel.class)) continue;
                panels.add((AbstractAnalysisPanel)((Object)classes[i].newInstance()));
                continue;
            }
            catch (Exception e2) {
                this.logError("Failed to instantiate analysis panel: " + classes[i], "Analysis panels");
            }
        }
        panels.add(0, new DefaultAnalysisPanel());
        this.m_ComboBoxPanels = new BaseComboBox((Object[])panels.toArray(new AbstractAnalysisPanel[0]));
        this.m_ComboBoxPanels.addActionListener(e -> this.updatePanel((AbstractAnalysisPanel)((Object)((Object)this.m_ComboBoxPanels.getSelectedItem()))));
        JPanel panel = new JPanel(new FlowLayout(0));
        this.add(panel, "North");
        JLabel label = new JLabel("Type");
        label.setLabelFor((Component)this.m_ComboBoxPanels);
        panel.add(label);
        panel.add((Component)this.m_ComboBoxPanels);
    }

    protected void finishInit() {
        super.finishInit();
        this.m_ComboBoxPanels.setSelectedIndex(0);
    }

    @Override
    protected void ownerChanged() {
        super.ownerChanged();
        if (this.getOwner() != null) {
            String preferred = ExperimenterPanel.getProperties().getProperty("ResultsInitialPanel", DefaultAnalysisPanel.class.getName());
            for (int i = 0; i < this.m_ComboBoxPanels.getItemCount(); ++i) {
                if (!((Object)((Object)((AbstractAnalysisPanel)((Object)this.m_ComboBoxPanels.getItemAt(i))))).getClass().getName().equals(preferred)) continue;
                this.updatePanel((AbstractAnalysisPanel)((Object)this.m_ComboBoxPanels.getItemAt(i)));
                break;
            }
        }
    }

    protected void updatePanel(AbstractAnalysisPanel panel) {
        Instances results = null;
        if (this.m_PanelAnalysis != null) {
            results = this.m_PanelAnalysis.getResults();
            this.remove((Component)((Object)this.m_PanelAnalysis));
        }
        this.m_PanelAnalysis = (AbstractAnalysisPanel)((Object)ObjectCopyHelper.copyObject((Object)((Object)panel)));
        this.add((Component)((Object)this.m_PanelAnalysis), "Center");
        this.m_PanelAnalysis.setResults(results);
    }

    public String handlesResults(Instances results) {
        if (this.m_PanelAnalysis != null) {
            return this.m_PanelAnalysis.handlesResults(results);
        }
        return "No analysis panel available!";
    }

    public boolean hasResults() {
        return this.getResults() != null;
    }

    public void setResults(Instances value) {
        if (this.m_PanelAnalysis != null) {
            this.m_PanelAnalysis.setResults(value);
        }
    }

    public Instances getResults() {
        if (this.m_PanelAnalysis != null) {
            return this.m_PanelAnalysis.getResults();
        }
        return null;
    }

    public Icon getTabIcon() {
        return GUIHelper.getIcon((String)"glasses.gif");
    }
}

