/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter.setup;

import adams.core.ClassLister;
import adams.gui.core.GUIHelper;
import adams.gui.tools.wekamultiexperimenter.AbstractExperimenterPanel;
import adams.gui.tools.wekamultiexperimenter.io.AbstractExperimentIO;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class AbstractSetupPanel<T>
extends AbstractExperimenterPanel {
    private static final long serialVersionUID = -7551590918482897687L;
    protected AbstractExperimentIO<T> m_ExperimentIO;
    protected boolean m_Modified;
    protected boolean m_IgnoreChanges;

    protected void initialize() {
        super.initialize();
        this.m_ExperimentIO = this.createExperimentIO();
        this.m_Modified = false;
        this.m_IgnoreChanges = false;
    }

    public abstract String getSetupName();

    protected abstract AbstractExperimentIO<T> createExperimentIO();

    public AbstractExperimentIO<T> getExperimentIO() {
        return this.m_ExperimentIO;
    }

    public abstract T getExperiment();

    public void setIgnoreChanges(boolean value) {
        this.m_IgnoreChanges = value;
    }

    public abstract void setExperiment(T var1);

    public abstract String handlesExperiment(T var1);

    public void setModified(boolean value) {
        if (this.m_IgnoreChanges) {
            return;
        }
        this.m_Modified = value;
        if (this.getOwner() != null) {
            this.getOwner().update();
        }
    }

    public boolean isModified() {
        return this.m_Modified;
    }

    public Icon getTabIcon() {
        return GUIHelper.getIcon((String)"settings.png");
    }

    public static Class[] getPanels() {
        return ClassLister.getSingleton().getClasses(AbstractSetupPanel.class);
    }

    public class ModificationActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractSetupPanel.this.setModified(true);
        }
    }

    public class ModificationChangeListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            AbstractSetupPanel.this.setModified(true);
        }
    }

    public class ModificationDocumentListener
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent e) {
            AbstractSetupPanel.this.setModified(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            AbstractSetupPanel.this.setModified(true);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            AbstractSetupPanel.this.setModified(true);
        }
    }
}

