/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter.setup;

import adams.core.base.BaseText;
import adams.core.io.PlaceholderFile;
import adams.data.weka.classattribute.AbstractClassAttributeHeuristic;
import adams.data.weka.classattribute.LastAttribute;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BaseComboBox;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.BaseTextArea;
import adams.gui.core.Fonts;
import adams.gui.core.NumberTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.tools.wekamultiexperimenter.experiment.AbstractExperiment;
import adams.gui.tools.wekamultiexperimenter.experiment.AbstractResultsHandler;
import adams.gui.tools.wekamultiexperimenter.experiment.CrossValidationExperiment;
import adams.gui.tools.wekamultiexperimenter.experiment.FileResultsHandler;
import adams.gui.tools.wekamultiexperimenter.experiment.TrainTestSplitExperiment;
import adams.gui.tools.wekamultiexperimenter.io.AbstractExperimentIO;
import adams.gui.tools.wekamultiexperimenter.io.DefaultAdamsExperimentIO;
import adams.gui.tools.wekamultiexperimenter.setup.AbstractAdamsSetupPanel;
import adams.gui.tools.wekamultiexperimenter.setup.AbstractSetupPanel;
import adams.gui.tools.wekamultiexperimenter.setup.ClassifierPanel;
import adams.gui.tools.wekamultiexperimenter.setup.DatasetPanel;
import adams.multiprocess.JobRunner;
import adams.multiprocess.LocalJobRunner;
import com.googlecode.jfilechooserbookmarks.gui.BaseScrollPane;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import weka.classifiers.CrossValidationFoldGenerator;
import weka.classifiers.DefaultCrossValidationFoldGenerator;
import weka.classifiers.DefaultRandomSplitGenerator;
import weka.classifiers.RandomSplitGenerator;
import weka.gui.experiment.ExperimenterDefaults;

public class BasicAdamsSetupPanel
extends AbstractAdamsSetupPanel {
    private static final long serialVersionUID = -5412911620981798767L;
    protected ParameterPanel m_PanelParameters;
    protected GenericObjectEditorPanel m_PanelResultsHandler;
    protected GenericObjectEditorPanel m_PanelClassAttribute;
    protected NumberTextField m_TextRepetitions;
    protected BaseComboBox<String> m_ComboBoxEvaluation;
    protected NumberTextField m_TextEvaluation;
    protected BaseCheckBox m_CheckBoxCustomSplitGenerator;
    protected GenericObjectEditorPanel m_PanelGenerator;
    protected GenericObjectEditorPanel m_PanelJobRunner;
    protected BaseTextArea m_TextNotes;
    protected BaseTabbedPane m_TabbedPane;
    protected DatasetPanel m_PanelDatasets;
    protected ClassifierPanel m_PanelClassifiers;

    protected void initGUI() {
        super.initGUI();
        JPanel panel = new JPanel(new FlowLayout(0));
        this.add(panel, "North");
        this.m_PanelParameters = new ParameterPanel();
        panel.add((Component)this.m_PanelParameters);
        this.m_PanelResultsHandler = new GenericObjectEditorPanel(AbstractResultsHandler.class, (Object)new FileResultsHandler(), true);
        this.m_PanelResultsHandler.addChangeListener((ChangeListener)new AbstractSetupPanel.ModificationChangeListener());
        this.m_PanelParameters.addParameter("Results", (Component)this.m_PanelResultsHandler);
        this.m_PanelClassAttribute = new GenericObjectEditorPanel(AbstractClassAttributeHeuristic.class, (Object)new LastAttribute(), true);
        this.m_PanelClassAttribute.addChangeListener((ChangeListener)new AbstractSetupPanel.ModificationChangeListener());
        this.m_PanelParameters.addParameter("Class attribute", (Component)this.m_PanelClassAttribute);
        this.m_TextRepetitions = new NumberTextField(NumberTextField.Type.INTEGER);
        this.m_TextRepetitions.setValue((Number)ExperimenterDefaults.getRepetitions());
        this.m_TextRepetitions.getDocument().addDocumentListener(new AbstractSetupPanel.ModificationDocumentListener());
        this.m_PanelParameters.addParameter("Repetitions", (Component)this.m_TextRepetitions);
        this.m_ComboBoxEvaluation = new BaseComboBox((Object[])new String[]{"Cross-validation", "Train/test split (randomized)", "Train/test split (order preserved)"});
        this.m_ComboBoxEvaluation.setSelectedIndex(0);
        int evalIndex = this.m_PanelParameters.addParameter("Evaluation", this.m_ComboBoxEvaluation);
        this.m_ComboBoxEvaluation.addActionListener(e -> {
            this.setModified(true);
            switch (this.m_ComboBoxEvaluation.getSelectedIndex()) {
                case -1: 
                case 0: {
                    this.m_PanelParameters.getLabel(evalIndex + 1).setText("Number of folds");
                    this.m_PanelParameters.setToolTipText(evalIndex + 1, "Use <2 for LOO-CV", true, true);
                    this.m_PanelGenerator.setClassType(CrossValidationFoldGenerator.class);
                    this.m_PanelGenerator.setCurrent((Object)new DefaultCrossValidationFoldGenerator());
                    break;
                }
                case 1: {
                    this.m_PanelParameters.getLabel(evalIndex + 1).setText("Split percentage");
                    this.m_PanelParameters.setToolTipText(evalIndex + 1, "A percentage between 0 and 100", true, true);
                    this.m_PanelGenerator.setClassType(RandomSplitGenerator.class);
                    DefaultRandomSplitGenerator gen = new DefaultRandomSplitGenerator();
                    gen.setPreserveOrder(false);
                    this.m_PanelGenerator.setCurrent((Object)gen);
                    break;
                }
                case 2: {
                    this.m_PanelParameters.getLabel(evalIndex + 1).setText("Split percentage");
                    this.m_PanelParameters.setToolTipText(evalIndex + 1, "A percentage between 0 and 100", true, true);
                    this.m_PanelGenerator.setClassType(RandomSplitGenerator.class);
                    DefaultRandomSplitGenerator gen = new DefaultRandomSplitGenerator();
                    gen.setPreserveOrder(true);
                    this.m_PanelGenerator.setCurrent((Object)gen);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled evaluation type: " + (String)this.m_ComboBoxEvaluation.getSelectedItem());
                }
            }
        });
        this.m_TextEvaluation = new NumberTextField(NumberTextField.Type.DOUBLE);
        this.m_TextEvaluation.getDocument().addDocumentListener(new AbstractSetupPanel.ModificationDocumentListener());
        this.m_PanelParameters.addParameter("", (Component)this.m_TextEvaluation);
        this.m_CheckBoxCustomSplitGenerator = new BaseCheckBox();
        this.m_CheckBoxCustomSplitGenerator.addActionListener((ActionListener)new AbstractSetupPanel.ModificationActionListener());
        this.m_PanelParameters.addParameter("Use custom split generator", (Component)this.m_CheckBoxCustomSplitGenerator);
        this.m_PanelGenerator = new GenericObjectEditorPanel(CrossValidationFoldGenerator.class, (Object)new DefaultCrossValidationFoldGenerator(), true);
        this.m_PanelGenerator.addChangeListener((ChangeListener)new AbstractSetupPanel.ModificationChangeListener());
        this.m_PanelParameters.addParameter("Split generator", (Component)this.m_PanelGenerator);
        this.m_PanelJobRunner = new GenericObjectEditorPanel(JobRunner.class, (Object)new LocalJobRunner(), true);
        this.m_PanelJobRunner.addChangeListener((ChangeListener)new AbstractSetupPanel.ModificationChangeListener());
        this.m_PanelParameters.addParameter("Job runner", (Component)this.m_PanelJobRunner);
        this.m_PanelDatasets = new DatasetPanel();
        this.m_PanelDatasets.setOwner(this);
        this.m_PanelClassifiers = new ClassifierPanel();
        this.m_PanelClassifiers.setOwner(this);
        this.m_TextNotes = new BaseTextArea();
        this.m_TextNotes.setTextFont(Fonts.getMonospacedFont());
        this.m_TextNotes.setLineWrap(true);
        this.m_TextNotes.setWrapStyleWord(true);
        this.m_TabbedPane = new BaseTabbedPane();
        this.m_TabbedPane.addTab("Datasets", (Component)((Object)this.m_PanelDatasets));
        this.m_TabbedPane.addTab("Classifiers", (Component)((Object)this.m_PanelClassifiers));
        this.m_TabbedPane.addTab("Notes", (Component)new BaseScrollPane((Component)this.m_TextNotes));
        this.add((Component)this.m_TabbedPane, "Center");
    }

    protected void finishInit() {
        super.finishInit();
        this.m_TextRepetitions.setValue((Number)10);
        this.m_ComboBoxEvaluation.setSelectedIndex(0);
        this.m_TextEvaluation.setValue((Number)10);
        this.setModified(false);
    }

    @Override
    public String getSetupName() {
        return "Basic (Adams)";
    }

    @Override
    protected AbstractExperimentIO<AbstractExperiment> createExperimentIO() {
        return new DefaultAdamsExperimentIO();
    }

    @Override
    public AbstractExperiment getExperiment() {
        AbstractExperiment result = (AbstractExperiment)this.getExperimentIO().create();
        switch (this.m_ComboBoxEvaluation.getSelectedIndex()) {
            case 0: {
                result = new CrossValidationExperiment();
                ((CrossValidationExperiment)result).setFolds(this.m_TextEvaluation.getValue((Number)10).intValue());
                if (!this.m_CheckBoxCustomSplitGenerator.isSelected() || !(this.m_PanelGenerator.getCurrent() instanceof CrossValidationFoldGenerator)) break;
                ((CrossValidationExperiment)result).setGenerator((CrossValidationFoldGenerator)this.m_PanelGenerator.getCurrent());
                break;
            }
            case 1: {
                result = new TrainTestSplitExperiment();
                ((TrainTestSplitExperiment)result).setPercentage(this.m_TextEvaluation.getValue((Number)66.0).doubleValue());
                ((TrainTestSplitExperiment)result).setPreserveOrder(false);
                if (!this.m_CheckBoxCustomSplitGenerator.isSelected() || !(this.m_PanelGenerator.getCurrent() instanceof RandomSplitGenerator)) break;
                ((TrainTestSplitExperiment)result).setGenerator((RandomSplitGenerator)this.m_PanelGenerator.getCurrent());
                break;
            }
            case 2: {
                result = new TrainTestSplitExperiment();
                ((TrainTestSplitExperiment)result).setPercentage(this.m_TextEvaluation.getValue((Number)66.0).doubleValue());
                ((TrainTestSplitExperiment)result).setPreserveOrder(true);
                if (!this.m_CheckBoxCustomSplitGenerator.isSelected() || !(this.m_PanelGenerator.getCurrent() instanceof RandomSplitGenerator)) break;
                ((TrainTestSplitExperiment)result).setGenerator((RandomSplitGenerator)this.m_PanelGenerator.getCurrent());
                break;
            }
            default: {
                this.logMessage("Unhandled evaluation type: " + (String)this.m_ComboBoxEvaluation.getSelectedItem());
            }
        }
        result.setResultsHandler((AbstractResultsHandler)((Object)this.m_PanelResultsHandler.getCurrent()));
        result.setClassAttribute((AbstractClassAttributeHeuristic)((Object)this.m_PanelClassAttribute.getCurrent()));
        result.setRuns(this.m_TextRepetitions.getValue().intValue());
        result.setJobRunner((JobRunner)this.m_PanelJobRunner.getCurrent());
        result.setClassifiers(this.m_PanelClassifiers.getClassifiers());
        result.setNotes(new BaseText(this.m_TextNotes.getText()));
        for (File file : this.m_PanelDatasets.getFiles()) {
            result.addDataset(new PlaceholderFile(file));
        }
        return result;
    }

    @Override
    public void setExperiment(AbstractExperiment value) {
        if (this.handlesExperiment(value) == null) {
            if (value instanceof CrossValidationExperiment) {
                this.m_ComboBoxEvaluation.setSelectedIndex(0);
                this.m_TextEvaluation.setValue((Number)((CrossValidationExperiment)value).getFolds());
                CrossValidationFoldGenerator generator = ((CrossValidationExperiment)value).getGenerator();
                if (!generator.toCommandLine().equals(new DefaultCrossValidationFoldGenerator().toCommandLine())) {
                    this.m_CheckBoxCustomSplitGenerator.setSelected(true);
                    this.m_PanelGenerator.setCurrent((Object)generator);
                } else {
                    this.m_CheckBoxCustomSplitGenerator.setSelected(false);
                    this.m_PanelGenerator.setCurrent((Object)new DefaultCrossValidationFoldGenerator());
                }
            } else if (value instanceof TrainTestSplitExperiment) {
                if (((TrainTestSplitExperiment)value).getPreserveOrder()) {
                    this.m_ComboBoxEvaluation.setSelectedIndex(2);
                } else {
                    this.m_ComboBoxEvaluation.setSelectedIndex(1);
                }
                this.m_TextEvaluation.setValue((Number)((TrainTestSplitExperiment)value).getPercentage());
                RandomSplitGenerator generator = ((TrainTestSplitExperiment)value).getGenerator();
                if (!generator.toCommandLine().equals(new DefaultRandomSplitGenerator().toCommandLine())) {
                    this.m_CheckBoxCustomSplitGenerator.setSelected(true);
                    this.m_PanelGenerator.setCurrent((Object)generator);
                } else {
                    this.m_CheckBoxCustomSplitGenerator.setSelected(false);
                    this.m_PanelGenerator.setCurrent((Object)new DefaultRandomSplitGenerator());
                }
            } else {
                this.logMessage("Unhandled experiment type: " + value.getClass().getName());
            }
        } else {
            throw new IllegalArgumentException("Cannot handle experiment: " + value.getClass().getName());
        }
        this.m_PanelResultsHandler.setCurrent((Object)value.getResultsHandler());
        this.m_PanelClassAttribute.setCurrent((Object)value.getClassAttribute());
        this.m_TextRepetitions.setValue((Number)value.getRuns());
        this.m_PanelJobRunner.setCurrent((Object)value.getJobRunner());
        this.m_PanelDatasets.setFiles((File[])value.getDatasets());
        this.m_PanelClassifiers.setClassifiers(value.getClassifiers());
        this.m_TextNotes.setText(value.getNotes().getValue());
    }

    @Override
    public String handlesExperiment(AbstractExperiment exp) {
        if (exp instanceof CrossValidationExperiment) {
            return null;
        }
        if (exp instanceof TrainTestSplitExperiment) {
            return null;
        }
        return "Unsupported experiment type: " + exp.getClass().getName();
    }
}

