/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter.setup;

import adams.gui.core.BaseComboBox;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.NumberTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.tools.wekamultiexperimenter.io.AbstractExperimentIO;
import adams.gui.tools.wekamultiexperimenter.io.DefaultWekaExperimentIO;
import adams.gui.tools.wekamultiexperimenter.setup.AbstractSetupPanel;
import adams.gui.tools.wekamultiexperimenter.setup.AbstractWekaSetupPanel;
import adams.gui.tools.wekamultiexperimenter.setup.ClassifierPanel;
import adams.gui.tools.wekamultiexperimenter.setup.DatasetPanel;
import adams.gui.tools.wekamultiexperimenter.setup.weka.OutputPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import javax.swing.JPanel;
import weka.classifiers.Classifier;
import weka.experiment.ClassifierSplitEvaluator;
import weka.experiment.CrossValidationResultProducer;
import weka.experiment.Experiment;
import weka.experiment.PropertyNode;
import weka.experiment.RandomSplitResultProducer;
import weka.experiment.RegressionSplitEvaluator;
import weka.experiment.RemoteExperiment;
import weka.experiment.ResultProducer;
import weka.experiment.SplitEvaluator;
import weka.gui.experiment.ExperimenterDefaults;

public class BasicWekaSetupPanel
extends AbstractWekaSetupPanel {
    private static final long serialVersionUID = -5412911620981798767L;
    protected ParameterPanel m_PanelParameters;
    protected OutputPanel m_PanelOutput;
    protected NumberTextField m_TextRepetitions;
    protected BaseComboBox m_ComboBoxClassificationRegression;
    protected BaseComboBox<String> m_ComboBoxEvaluation;
    protected NumberTextField m_TextEvaluation;
    protected BaseComboBox<String> m_ComboBoxOrder;
    protected BaseTabbedPane m_TabbedPane;
    protected DatasetPanel m_PanelDatasets;
    protected ClassifierPanel m_PanelClassifiers;

    protected void initGUI() {
        super.initGUI();
        JPanel panel = new JPanel(new FlowLayout(0));
        this.add(panel, "North");
        this.m_PanelParameters = new ParameterPanel();
        panel.add((Component)this.m_PanelParameters);
        this.m_PanelOutput = new OutputPanel();
        this.m_PanelOutput.setOwner(this);
        this.m_PanelParameters.addParameter("Output", (Component)((Object)this.m_PanelOutput));
        this.m_TextRepetitions = new NumberTextField(NumberTextField.Type.INTEGER);
        this.m_TextRepetitions.setValue((Number)ExperimenterDefaults.getRepetitions());
        this.m_TextRepetitions.getDocument().addDocumentListener(new AbstractSetupPanel.ModificationDocumentListener(this));
        this.m_PanelParameters.addParameter("Repetitions", (Component)this.m_TextRepetitions);
        this.m_ComboBoxClassificationRegression = new BaseComboBox((Object[])new String[]{"Classification", "Regression"});
        this.m_ComboBoxClassificationRegression.addActionListener((ActionListener)new AbstractSetupPanel.ModificationActionListener(this));
        this.m_PanelParameters.addParameter("Task", (Component)this.m_ComboBoxClassificationRegression);
        this.m_ComboBoxEvaluation = new BaseComboBox((Object[])new String[]{"Cross-validation", "Train/test split (randomized)", "Train/test split (order preserved)"});
        this.m_ComboBoxEvaluation.setSelectedIndex(0);
        int evalIndex = this.m_PanelParameters.addParameter("Evaluation", this.m_ComboBoxEvaluation);
        this.m_ComboBoxEvaluation.addActionListener(e -> {
            this.setModified(true);
            switch (this.m_ComboBoxEvaluation.getSelectedIndex()) {
                case -1: 
                case 0: {
                    this.m_PanelParameters.getLabel(evalIndex + 1).setText("Number of folds");
                    break;
                }
                case 1: 
                case 2: {
                    this.m_PanelParameters.getLabel(evalIndex + 1).setText("Split percentage");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled evaluation type: " + (String)this.m_ComboBoxEvaluation.getSelectedItem());
                }
            }
        });
        this.m_TextEvaluation = new NumberTextField(NumberTextField.Type.DOUBLE);
        this.m_TextEvaluation.getDocument().addDocumentListener(new AbstractSetupPanel.ModificationDocumentListener(this));
        this.m_PanelParameters.addParameter("", (Component)this.m_TextEvaluation);
        this.m_ComboBoxOrder = new BaseComboBox((Object[])new String[]{"Datasets -> Classifiers", "Classifiers -> Datasets"});
        this.m_ComboBoxOrder.addActionListener((ActionListener)new AbstractSetupPanel.ModificationActionListener(this));
        this.m_PanelParameters.addParameter("Iteration", this.m_ComboBoxOrder);
        this.m_PanelDatasets = new DatasetPanel();
        this.m_PanelDatasets.setOwner(this);
        this.m_PanelClassifiers = new ClassifierPanel();
        this.m_PanelClassifiers.setOwner(this);
        this.m_TabbedPane = new BaseTabbedPane();
        this.m_TabbedPane.addTab("Datasets", (Component)((Object)this.m_PanelDatasets));
        this.m_TabbedPane.addTab("Classifiers", (Component)((Object)this.m_PanelClassifiers));
        this.add((Component)this.m_TabbedPane, "Center");
    }

    protected void finishInit() {
        super.finishInit();
        this.m_TextRepetitions.setValue((Number)10);
        this.m_ComboBoxClassificationRegression.setSelectedIndex(0);
        this.m_ComboBoxEvaluation.setSelectedIndex(0);
        this.m_TextEvaluation.setValue((Number)10);
        this.m_ComboBoxOrder.setSelectedIndex(0);
        this.setModified(false);
    }

    @Override
    public String getSetupName() {
        return "Basic (Weka)";
    }

    @Override
    protected AbstractExperimentIO<Experiment> createExperimentIO() {
        return new DefaultWekaExperimentIO();
    }

    @Override
    public Experiment getExperiment() {
        File[] files;
        Classifier sec;
        ClassifierSplitEvaluator se;
        Experiment result = (Experiment)this.getExperimentIO().create();
        result.setResultListener(this.m_PanelOutput.getResultListener());
        result.setPropertyArray((Object)new Classifier[0]);
        result.setUsePropertyIterator(true);
        result.setRunLower(1);
        result.setRunUpper(this.m_TextRepetitions.getValue().intValue());
        result.setAdvanceDataSetFirst(this.m_ComboBoxOrder.getSelectedIndex() <= 0);
        switch (this.m_ComboBoxClassificationRegression.getSelectedIndex()) {
            case 0: {
                se = new ClassifierSplitEvaluator();
                sec = se.getClassifier();
                break;
            }
            case 1: {
                se = new RegressionSplitEvaluator();
                sec = ((RegressionSplitEvaluator)se).getClassifier();
                break;
            }
            default: {
                throw new IllegalStateException("Either select classification or regression!");
            }
        }
        switch (this.m_ComboBoxEvaluation.getSelectedIndex()) {
            case -1: 
            case 0: {
                CrossValidationResultProducer cvrp = new CrossValidationResultProducer();
                cvrp.setNumFolds(this.m_TextEvaluation.getValue((Number)10).intValue());
                cvrp.setSplitEvaluator((SplitEvaluator)se);
                PropertyNode[] propertyPath = new PropertyNode[2];
                try {
                    propertyPath[0] = new PropertyNode((Object)se, new PropertyDescriptor("splitEvaluator", CrossValidationResultProducer.class), CrossValidationResultProducer.class);
                    propertyPath[1] = new PropertyNode((Object)sec, new PropertyDescriptor("classifier", se.getClass()), se.getClass());
                }
                catch (IntrospectionException e) {
                    e.printStackTrace();
                }
                result.setResultProducer((ResultProducer)cvrp);
                result.setPropertyPath(propertyPath);
                break;
            }
            case 1: 
            case 2: {
                RandomSplitResultProducer rsrp = new RandomSplitResultProducer();
                rsrp.setRandomizeData(this.m_ComboBoxEvaluation.getSelectedIndex() == 1);
                rsrp.setTrainPercent(this.m_TextEvaluation.getValue((Number)66.0).doubleValue());
                rsrp.setSplitEvaluator((SplitEvaluator)se);
                PropertyNode[] propertyPath = new PropertyNode[2];
                try {
                    propertyPath[0] = new PropertyNode((Object)se, new PropertyDescriptor("splitEvaluator", RandomSplitResultProducer.class), RandomSplitResultProducer.class);
                    propertyPath[1] = new PropertyNode((Object)sec, new PropertyDescriptor("classifier", se.getClass()), se.getClass());
                }
                catch (IntrospectionException e) {
                    e.printStackTrace();
                }
                result.setResultProducer((ResultProducer)rsrp);
                result.setPropertyPath(propertyPath);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled evaluation: " + (String)this.m_ComboBoxEvaluation.getSelectedItem());
            }
        }
        for (File file : files = this.m_PanelDatasets.getFiles()) {
            result.getDatasets().addElement(file);
        }
        Classifier[] classifiers = this.m_PanelClassifiers.getClassifiers();
        result.setPropertyArray((Object)classifiers);
        return result;
    }

    @Override
    public void setExperiment(Experiment value) {
        File[] files;
        if (this.handlesExperiment(value) == null) {
            this.m_PanelOutput.setResultListener(value.getResultListener());
            this.m_TextRepetitions.setValue((Number)value.getRunUpper());
            this.m_ComboBoxOrder.setSelectedIndex(value.getAdvanceDataSetFirst() ? 0 : 1);
            if (value.getResultProducer() instanceof CrossValidationResultProducer) {
                CrossValidationResultProducer cvrp = (CrossValidationResultProducer)value.getResultProducer();
                this.m_ComboBoxEvaluation.setSelectedIndex(0);
                this.m_TextEvaluation.setValue((Number)cvrp.getNumFolds());
                if (cvrp.getSplitEvaluator() instanceof ClassifierSplitEvaluator) {
                    this.m_ComboBoxClassificationRegression.setSelectedIndex(0);
                } else if (cvrp.getSplitEvaluator() instanceof RegressionSplitEvaluator) {
                    this.m_ComboBoxClassificationRegression.setSelectedIndex(1);
                }
            } else if (value.getResultProducer() instanceof RandomSplitResultProducer) {
                RandomSplitResultProducer rsrp = (RandomSplitResultProducer)value.getResultProducer();
                if (rsrp.getRandomizeData()) {
                    this.m_ComboBoxEvaluation.setSelectedIndex(1);
                } else {
                    this.m_ComboBoxEvaluation.setSelectedIndex(2);
                }
                this.m_TextEvaluation.setValue((Number)rsrp.getTrainPercent());
                if (rsrp.getSplitEvaluator() instanceof ClassifierSplitEvaluator) {
                    this.m_ComboBoxClassificationRegression.setSelectedIndex(0);
                } else if (rsrp.getSplitEvaluator() instanceof RegressionSplitEvaluator) {
                    this.m_ComboBoxClassificationRegression.setSelectedIndex(1);
                }
            }
            files = new File[value.getDatasets().size()];
            for (int i = 0; i < value.getDatasets().size(); ++i) {
                files[i] = (File)value.getDatasets().get(i);
            }
        } else {
            throw new IllegalArgumentException("Cannot handle experiment: " + value.getClass().getName());
        }
        this.m_PanelDatasets.setFiles(files);
        Classifier[] classifiers = value.getPropertyArray() instanceof Classifier[] ? (Classifier[])value.getPropertyArray() : new Classifier[]{};
        this.m_PanelClassifiers.setClassifiers(classifiers);
    }

    @Override
    public String handlesExperiment(Experiment exp) {
        if (exp instanceof RemoteExperiment) {
            return "Cannot handle remote experiment";
        }
        if (!exp.getUsePropertyIterator()) {
            return "Does not use property iterator";
        }
        if (!(exp.getPropertyArray() instanceof Classifier[])) {
            return "Does not iterate on classifier";
        }
        if (exp.getRunLower() != 1) {
            return "Lower run number must be 1";
        }
        if (!(exp.getResultProducer() instanceof CrossValidationResultProducer) && !(exp.getResultProducer() instanceof RandomSplitResultProducer)) {
            return "Can only handle " + CrossValidationResultProducer.class.getName() + " or " + RandomSplitResultProducer.class.getName();
        }
        SplitEvaluator spliteval = null;
        if (exp.getResultProducer() instanceof CrossValidationResultProducer) {
            spliteval = ((CrossValidationResultProducer)exp.getResultProducer()).getSplitEvaluator();
        } else if (exp.getResultProducer() instanceof RandomSplitResultProducer) {
            spliteval = ((RandomSplitResultProducer)exp.getResultProducer()).getSplitEvaluator();
        }
        if (!(spliteval instanceof ClassifierSplitEvaluator) && !(spliteval instanceof RegressionSplitEvaluator)) {
            return "Can only handle " + ClassifierSplitEvaluator.class.getName() + " and " + RegressionSplitEvaluator.class.getName() + "";
        }
        return null;
    }
}

