/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instance;

import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.gui.core.ColorHelper;
import adams.gui.visualization.instance.InstanceContainer;
import adams.gui.visualization.instance.InstanceLinePaintlet;
import java.awt.Color;

public class ReportColorInstancePaintlet
extends InstanceLinePaintlet {
    private static final long serialVersionUID = -4837316110207980301L;
    protected Field m_ColorField;
    protected Color m_DefaultColor;
    protected boolean m_UpdateContainerColor;

    @Override
    public String globalInfo() {
        return "Paintlet for generating a line plot using the color stored in the report.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color-field", "colorField", (Object)new Field("Color", DataType.STRING));
        this.m_OptionManager.add("default-color", "defaultColor", (Object)Color.BLACK);
        this.m_OptionManager.add("update-container-color", "updateContainerColor", (Object)false);
    }

    public void setColorField(Field value) {
        this.m_ColorField = value;
        this.memberChanged();
    }

    public Field getColorField() {
        return this.m_ColorField;
    }

    public String colorFieldTipText() {
        return "The report field that contains the color information.";
    }

    public void setDefaultColor(Color value) {
        this.m_DefaultColor = value;
        this.memberChanged();
    }

    public Color getDefaultColor() {
        return this.m_DefaultColor;
    }

    public String defaultColorTipText() {
        return "The default color to use if no color information in the report.";
    }

    public void setUpdateContainerColor(boolean value) {
        this.m_UpdateContainerColor = value;
        this.memberChanged();
    }

    public boolean getUpdateContainerColor() {
        return this.m_UpdateContainerColor;
    }

    public String updateContainerColorTipText() {
        return "If enabled, the color of the container gets updated with the color determined by this paintlet.";
    }

    @Override
    public Color getColor(int index) {
        Color result = this.m_DefaultColor;
        InstanceContainer cont = (InstanceContainer)this.getDataContainerPanel().getContainerManager().get(index);
        if (cont.getData().getReport().hasValue((AbstractField)this.m_ColorField)) {
            try {
                result = ColorHelper.valueOf((String)cont.getData().getReport().getStringValue((AbstractField)this.m_ColorField));
            }
            catch (Exception e) {
                this.getLogger().warning("Unparseable color: " + cont.getData().getReport().getValue((AbstractField)this.m_ColorField));
                result = this.m_DefaultColor;
            }
        }
        if (this.m_UpdateContainerColor && !cont.getColor().equals(result)) {
            cont.setColor(result);
        }
        return result;
    }
}

