/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances.instancestable;

import adams.core.Properties;
import adams.core.Utils;
import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.ArrayMean;
import adams.data.statistics.StatUtils;
import adams.data.weka.WekaAttributeRange;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.PropertiesParameterPanel;
import adams.gui.dialog.PropertiesParameterDialog;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.visualization.instances.InstancesTable;
import adams.gui.visualization.instances.instancestable.AbstractProcessSelectedRows;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItemHelper;
import adams.gui.visualization.instances.instancestable.ProcessRow;
import gnu.trove.list.array.TDoubleArrayList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.io.Serializable;
import weka.core.Instances;

public class ArrayStatistic
extends AbstractProcessSelectedRows
implements ProcessRow {
    private static final long serialVersionUID = 3101728458818516005L;
    public static final String KEY_ATTRIBUTES = "attributes";
    public static final String KEY_STATISTIC = "statistic";

    public String globalInfo() {
        return "Allows the user to calculate array statistics from selected rows (internal format).";
    }

    @Override
    protected String getDefaultMenuItem() {
        return "Array statistics...";
    }

    @Override
    public int minNumRows() {
        return 1;
    }

    @Override
    public int maxNumRows() {
        return -1;
    }

    protected double[] subset(double[] values, int[] atts) {
        TDoubleArrayList result = new TDoubleArrayList();
        for (int col : atts) {
            result.add(values[col]);
        }
        return result.toArray();
    }

    protected Properties promptParameters(InstancesTable table) {
        PropertiesParameterDialog dialog = GUIHelper.getParentDialog((Container)((Object)table)) != null ? new PropertiesParameterDialog(GUIHelper.getParentDialog((Container)((Object)table)), Dialog.ModalityType.DOCUMENT_MODAL) : new PropertiesParameterDialog(GUIHelper.getParentFrame((Container)((Object)table)), true);
        PropertiesParameterPanel panel = dialog.getPropertiesParameterPanel();
        panel.addPropertyType(KEY_ATTRIBUTES, PropertiesParameterPanel.PropertyType.RANGE);
        panel.setLabel(KEY_ATTRIBUTES, "Attributes");
        panel.setHelp(KEY_ATTRIBUTES, "The attributes to operate on");
        panel.addPropertyType(KEY_STATISTIC, PropertiesParameterPanel.PropertyType.OBJECT_EDITOR);
        panel.setLabel(KEY_STATISTIC, "Array statistic");
        panel.setHelp(KEY_STATISTIC, "The array statistics to apply");
        panel.setChooser(KEY_STATISTIC, (AbstractChooserPanel)new GenericObjectEditorPanel(AbstractArrayStatistic.class, (Object)new ArrayMean(), true));
        panel.setPropertyOrder(new String[]{KEY_ATTRIBUTES, KEY_STATISTIC});
        Properties last = new Properties();
        last.setProperty(KEY_ATTRIBUTES, "first-last");
        last.setObject(KEY_STATISTIC, (Object)new ArrayMean());
        dialog.setProperties(last);
        last = (Properties)table.getLastSetup(this.getClass(), true, false);
        if (last != null) {
            dialog.setProperties(last);
        }
        dialog.setTitle(this.getMenuItem());
        dialog.pack();
        dialog.setLocationRelativeTo((Component)table.getParent());
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return null;
        }
        return dialog.getProperties();
    }

    @Override
    protected boolean doProcessSelectedRows(InstancesTablePopupMenuItemHelper.TableState state) {
        AbstractArrayStatistic.StatisticContainer stats;
        int[] rows = Utils.adjustIndices((int[])state.actRows, (int)1);
        Properties last = this.promptParameters(state.table);
        if (last == null) {
            return false;
        }
        AbstractArrayStatistic array = (AbstractArrayStatistic)last.getObject(KEY_STATISTIC, AbstractArrayStatistic.class);
        if (array == null) {
            GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)((Object)state.table)), (String)"Failed to instantiate array statistic!");
            return false;
        }
        if (array.getMin() != -1 && array.getMin() > state.actRows.length) {
            GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)((Object)state.table)), (String)("Statistic " + Utils.classToString((Object)last) + " requires at least " + array.getMin() + " rows!"));
        }
        if (array.getMax() != -1 && array.getMax() < state.actRows.length) {
            GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)((Object)state.table)), (String)("Statistic " + Utils.classToString((Object)last) + " can only handle at most " + array.getMax() + " rows!"));
        }
        state.table.addLastSetup(this.getClass(), true, false, last);
        Instances data = state.table.toInstances(state.range, true);
        WekaAttributeRange range = new WekaAttributeRange(last.getProperty(KEY_ATTRIBUTES));
        range.setData(data);
        int[] atts = range.getIntIndices();
        for (int row = 0; row < data.numInstances(); ++row) {
            array.add((Serializable[])StatUtils.toNumberArray((double[])this.subset(data.instance(row).toDoubleArray(), atts)));
        }
        try {
            stats = array.calculate();
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)((Object)state.table)), (String)("Failed to calculate statistics for rows #" + Utils.arrayToString((Object)rows) + "!"), (Throwable)e);
            return false;
        }
        SpreadSheetDialog dialog = GUIHelper.getParentDialog((Container)((Object)state.table)) != null ? new SpreadSheetDialog(GUIHelper.getParentDialog((Container)((Object)state.table)), Dialog.ModalityType.MODELESS) : new SpreadSheetDialog(GUIHelper.getParentFrame((Container)((Object)state.table)), false);
        dialog.setDefaultCloseOperation(2);
        dialog.setTitle("Statistics for rows #" + Utils.arrayToString((Object)rows));
        dialog.setSpreadSheet(stats.toSpreadSheet());
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        return true;
    }

    @Override
    public boolean processRow(InstancesTablePopupMenuItemHelper.TableState state) {
        return this.processSelectedRows(state);
    }
}

