/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances.instancestable;

import adams.core.Properties;
import adams.core.option.AbstractOptionHandler;
import adams.data.binning.Bin;
import adams.data.binning.algorithm.BinningAlgorithm;
import adams.data.binning.algorithm.ManualBinning;
import adams.data.binning.operation.Wrapping;
import adams.data.container.DataPoint;
import adams.data.sequence.XYSequencePointComparator;
import adams.data.weka.WekaAttributeRange;
import adams.flow.sink.sequenceplotter.SequencePlotPoint;
import adams.flow.sink.sequenceplotter.SequencePlotSequence;
import adams.flow.sink.sequenceplotter.SequencePlotterPanel;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.PropertiesParameterPanel;
import adams.gui.core.TableRowRange;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.dialog.PropertiesParameterDialog;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.TranslucentColorProvider;
import adams.gui.visualization.core.axis.FancyTickGenerator;
import adams.gui.visualization.core.axis.SimpleFixedLabelTickGenerator;
import adams.gui.visualization.core.axis.TickGenerator;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItem;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItemHelper;
import adams.gui.visualization.instances.instancestable.PlotColumn;
import adams.gui.visualization.instances.instancestable.PlotRow;
import adams.gui.visualization.sequence.BarPaintlet;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import gnu.trove.list.array.TDoubleArrayList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.util.List;
import weka.core.Instances;

public class Binning
extends AbstractOptionHandler
implements PlotColumn,
PlotRow {
    private static final long serialVersionUID = -2452746814708360637L;
    public static final String KEY_COLUMNS = "columns";
    public static final String KEY_BINNING = "binning";

    public String globalInfo() {
        return "Allows to perform binning of the values from a column or row.";
    }

    @Override
    public String getMenuItem() {
        return "Binning...";
    }

    @Override
    public String getIconName() {
        return null;
    }

    @Override
    public boolean isAvailable(InstancesTablePopupMenuItemHelper.TableState state) {
        return true;
    }

    @Override
    public int compareTo(InstancesTablePopupMenuItem o) {
        return this.getMenuItem().compareTo(o.getMenuItem());
    }

    public boolean handlesRowRange(TableRowRange range) {
        return true;
    }

    protected Properties promptParameters(InstancesTablePopupMenuItemHelper.TableState state, boolean isColumn) {
        PropertiesParameterDialog dialog = GUIHelper.getParentDialog((Container)((Object)state.table)) != null ? new PropertiesParameterDialog(GUIHelper.getParentDialog((Container)((Object)state.table)), Dialog.ModalityType.DOCUMENT_MODAL) : new PropertiesParameterDialog(GUIHelper.getParentFrame((Container)((Object)state.table)), true);
        PropertiesParameterPanel panel = dialog.getPropertiesParameterPanel();
        if (!isColumn) {
            panel.addPropertyType(KEY_COLUMNS, PropertiesParameterPanel.PropertyType.RANGE);
            panel.setLabel(KEY_COLUMNS, "Columns");
            panel.setHelp(KEY_COLUMNS, "The columns to use for the histogram");
        }
        panel.addPropertyType(KEY_BINNING, PropertiesParameterPanel.PropertyType.OBJECT_EDITOR);
        panel.setLabel(KEY_BINNING, "Algorithm");
        panel.setHelp(KEY_BINNING, "The binning algorithm to apply");
        panel.setChooser(KEY_BINNING, (AbstractChooserPanel)new GenericObjectEditorPanel(BinningAlgorithm.class, (Object)new ManualBinning(), true));
        if (!isColumn) {
            panel.setPropertyOrder(new String[]{KEY_COLUMNS, KEY_BINNING});
        }
        Properties last = new Properties();
        if (!isColumn) {
            last.setProperty(KEY_COLUMNS, "first-last");
        }
        last.setObject(KEY_BINNING, (Object)new ManualBinning());
        dialog.setProperties(last);
        last = (Properties)state.table.getLastSetup(this.getClass(), true, !isColumn);
        if (last != null) {
            dialog.setProperties(last);
        }
        dialog.setTitle(this.getMenuItem());
        dialog.pack();
        dialog.setLocationRelativeTo((Component)state.table.getParent());
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return null;
        }
        return dialog.getProperties();
    }

    protected void createPlot(InstancesTablePopupMenuItemHelper.TableState state, boolean isColumn, TDoubleArrayList list, String title) {
        List binnable;
        Properties last = (Properties)state.table.getLastSetup(this.getClass(), true, !isColumn);
        BinningAlgorithm binning = (BinningAlgorithm)last.getObject(KEY_BINNING, BinningAlgorithm.class, (Object)new ManualBinning());
        try {
            binnable = Wrapping.wrap((double[])list.toArray());
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)state.table.getParent(), (String)("Failed to wrap " + (isColumn ? "column" : "row") + " values!"), (Throwable)e);
            return;
        }
        List bins = binning.generateBins(binnable);
        ApprovalDialog dialog = GUIHelper.getParentDialog((Container)((Object)state.table)) != null ? new ApprovalDialog(GUIHelper.getParentDialog((Container)((Object)state.table)), Dialog.ModalityType.MODELESS) : new ApprovalDialog(GUIHelper.getParentFrame((Container)((Object)state.table)), false);
        dialog.setTitle(title);
        BarPaintlet paintlet = new BarPaintlet();
        paintlet.setWidth(10);
        SequencePlotterPanel plotPanel = new SequencePlotterPanel("Binning");
        plotPanel.setColorProvider((ColorProvider)new TranslucentColorProvider());
        plotPanel.setDataPaintlet((Paintlet)paintlet);
        plotPanel.getPlot().clearToolTipAxes();
        plotPanel.getPlot().getAxis(Axis.BOTTOM).setTickGenerator((TickGenerator)new SimpleFixedLabelTickGenerator());
        plotPanel.getPlot().getAxis(Axis.BOTTOM).setNumberFormat("");
        plotPanel.getPlot().getAxis(Axis.BOTTOM).setNthValueToShow(2);
        plotPanel.getPlot().getAxis(Axis.LEFT).setTickGenerator((TickGenerator)new FancyTickGenerator());
        plotPanel.getPlot().getAxis(Axis.LEFT).setNumberFormat("0.0");
        XYSequenceContainerManager manager = (XYSequenceContainerManager)plotPanel.getContainerManager();
        manager.startUpdate();
        SequencePlotSequence seq = new SequencePlotSequence();
        seq.setID(title);
        seq.setComparison(XYSequencePointComparator.Comparison.X);
        for (int i = 0; i < bins.size(); ++i) {
            double x = seq.putMappingX(((Bin)bins.get(i)).getInterval().getValue());
            SequencePlotPoint point = new SequencePlotPoint("" + seq.size(), x, (double)((Bin)bins.get(i)).size());
            seq.add((DataPoint)point);
        }
        XYSequenceContainer seqcont = manager.newContainer((Comparable)seq);
        manager.add(seqcont);
        manager.finishUpdate();
        dialog.getContentPane().add((Component)plotPanel, "Center");
        dialog.setSize(GUIHelper.getDefaultDialogDimension());
        dialog.setLocationRelativeTo(GUIHelper.getParentComponent((Component)((Object)state.table)));
        dialog.setVisible(true);
    }

    protected void plot(InstancesTablePopupMenuItemHelper.TableState state, boolean isColumn) {
        Instances data;
        Properties last = this.promptParameters(state, isColumn);
        if (last == null) {
            return;
        }
        state.table.addLastSetup(this.getClass(), true, !isColumn, last);
        int index = isColumn ? state.actCol : state.actRow;
        TDoubleArrayList list = new TDoubleArrayList();
        if (isColumn) {
            data = state.table.toInstances(state.range, true);
            for (int i = 0; i < data.numInstances(); ++i) {
                if (!data.attribute(index).isNumeric() || data.instance(i).isMissing(index)) continue;
                list.add(data.instance(i).value(index));
            }
        } else {
            data = state.table.getInstances();
            WekaAttributeRange columns = new WekaAttributeRange(last.getProperty(KEY_COLUMNS, "first-last"));
            columns.setData(data);
            int[] cols = columns.getIntIndices();
            for (int i = 0; i < cols.length; ++i) {
                if (!data.attribute(cols[i]).isNumeric() || data.instance(index).isMissing(cols[i])) continue;
                list.add(data.instance(index).value(cols[i]));
            }
        }
        String title = isColumn ? "Column " + (index + 1) + "/" + data.attribute(index).name() : "Row " + (index + 1);
        this.createPlot(state, isColumn, list, title);
    }

    @Override
    public boolean plotColumn(InstancesTablePopupMenuItemHelper.TableState state) {
        this.plot(state, true);
        return true;
    }

    @Override
    public boolean plotRow(InstancesTablePopupMenuItemHelper.TableState state) {
        this.plot(state, false);
        return true;
    }
}

