/*
 * Decompiled with CFR 0.152.
 */
package adams.opt.genetic;

import adams.core.discovery.AbstractDiscoveryHandler;
import adams.core.discovery.DefaultPropertyDiscovery;
import adams.core.discovery.PropertyPath;
import adams.core.discovery.genetic.AbstractGeneticDiscoveryHandler;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import adams.core.option.OptionUtils;
import adams.opt.genetic.AbstractClassifierBasedGeneticAlgorithmWithSecondEvaluation;
import adams.opt.genetic.AbstractGeneticAlgorithm;
import adams.opt.genetic.OutputType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class Hermione
extends AbstractClassifierBasedGeneticAlgorithmWithSecondEvaluation {
    private static final long serialVersionUID = -4982024446995877986L;
    protected AbstractGeneticDiscoveryHandler[] m_Handlers;
    protected List<Integer> m_numbits = null;
    protected List<Integer> m_start = null;

    public String globalInfo() {
        return "Hermione.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handlers", (Object)new AbstractGeneticDiscoveryHandler[0]);
    }

    public void setHandlers(AbstractGeneticDiscoveryHandler[] value) {
        this.m_Handlers = value;
        this.reset();
    }

    public AbstractGeneticDiscoveryHandler[] getHandlers() {
        return this.m_Handlers;
    }

    public String handlersTipText() {
        return "The discovery handlers to use.";
    }

    @Override
    protected OutputType getDefaultOutputType() {
        return OutputType.SETUP;
    }

    @Override
    protected HermioneJob newJob(int chromosome, int[] w, Instances data, Instances testData) {
        return new HermioneJob(this, chromosome, w, data, testData);
    }

    @Override
    protected void preRun() {
        super.preRun();
        if (this.m_Handlers.length == 0) {
            throw new IllegalStateException("No handlers defined!");
        }
        AbstractGeneticDiscoveryHandler[] handlers = new AbstractGeneticDiscoveryHandler[this.m_Handlers.length];
        for (int i = 0; i < this.m_Handlers.length; ++i) {
            handlers[i] = (AbstractGeneticDiscoveryHandler)this.m_Handlers[i].shallowCopy();
        }
        DefaultPropertyDiscovery discovery = new DefaultPropertyDiscovery();
        discovery.discover((AbstractDiscoveryHandler[])handlers, OptionUtils.shallowCopy((Object)this.m_Classifier));
        this.m_numbits = this.getNumBitsForAll(handlers);
        this.m_start = this.getStartPoints(handlers);
        this.init(this.m_NumChrom, this.getNumBits(handlers) * this.m_BitsPerGene);
        int pos = 0;
        int[] dummyWeights = new int[this.getNumBits(handlers)];
        for (AbstractGeneticDiscoveryHandler handler : handlers) {
            List conts = handler.getContainers();
            for (PropertyPath.PropertyContainer cont : conts) {
                if (handler.requiresInitialization()) {
                    handler.performInitialization((AbstractGeneticAlgorithm)this, cont);
                }
                String strArray = handler.pack(cont);
                int[] newWeights = this.stringToIntArray(strArray);
                for (int i = 0; i < this.m_ActualNumChrom; ++i) {
                    this.setBitsForPosition(i, dummyWeights, this.m_start, this.m_numbits, pos, newWeights);
                }
                ++pos;
            }
        }
        if (this.isLoggingEnabled()) {
            for (int i = 0; i < handlers.length; ++i) {
                this.getLogger().info(i + 1 + ". " + OptionUtils.getCommandLine((Object)handlers[i]));
                for (PropertyPath.PropertyContainer cont : handlers[i].getContainers()) {
                    this.getLogger().info("   " + cont.getPath());
                }
            }
        }
    }

    public int[] stringToIntArray(String s) {
        int[] result = new int[s.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = s.charAt(i) == '0' ? 0 : 1;
        }
        return result;
    }

    public String intArrayToString(int[] ia) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < ia.length; ++i) {
            result.append("" + ia[i]);
        }
        return result.toString();
    }

    public void setBitsForPosition(int chromosome, int[] weights, List<Integer> starts, List<Integer> numbits, int pos, int[] newWeights) {
        int c = 0;
        if (newWeights.length != numbits.get(pos)) {
            this.getLogger().warning("[setBitsForPosition] Number of expected bits differs from length of supplied weights: " + numbits.get(pos) + " != " + newWeights.length);
        }
        for (int i = starts.get(pos).intValue(); i < starts.get(pos) + numbits.get(pos) && c < newWeights.length; ++c, ++i) {
            weights[i] = newWeights[c];
            if (newWeights[c] == 1) {
                this.m_Genes[chromosome].set(i);
                continue;
            }
            this.m_Genes[chromosome].clear(i);
        }
    }

    public int[] getBitsForPosition(int[] weights, List<Integer> starts, List<Integer> numbits, int pos) {
        int[] ret = new int[numbits.get(pos).intValue()];
        int c = 0;
        for (int i = starts.get(pos).intValue(); i < starts.get(pos) + numbits.get(pos); ++i) {
            ret[c++] = weights[i];
        }
        return ret;
    }

    public List<Integer> getNumBitsForAll(AbstractGeneticDiscoveryHandler[] handlers) {
        ArrayList<Integer> al = new ArrayList<Integer>();
        for (AbstractGeneticDiscoveryHandler handler : handlers) {
            List conts = handler.getContainers();
            for (PropertyPath.PropertyContainer cont : conts) {
                al.add(handler.getNumBits());
            }
        }
        return al;
    }

    public List<Integer> getStartPoints(AbstractGeneticDiscoveryHandler[] handlers) {
        ArrayList<Integer> al = new ArrayList<Integer>();
        int count = 0;
        for (AbstractGeneticDiscoveryHandler handler : handlers) {
            List conts = handler.getContainers();
            for (PropertyPath.PropertyContainer cont : conts) {
                al.add(count);
                count += handler.getNumBits();
            }
        }
        return al;
    }

    public int getNumBits(AbstractGeneticDiscoveryHandler[] handlers) {
        int count = 0;
        for (AbstractGeneticDiscoveryHandler handler : handlers) {
            List conts = handler.getContainers();
            for (PropertyPath.PropertyContainer cont : conts) {
                count += handler.getNumBits();
            }
        }
        return count;
    }

    public Classifier generateClassifier(int chromosome, int[] weights) {
        int i;
        if (LoggingHelper.isAtLeast((Logger)this.getLogger(), (Level)Level.FINE)) {
            StringBuilder w = new StringBuilder();
            for (i = 0; i < weights.length; ++i) {
                w.append(weights[i]);
            }
            this.getLogger().fine("[generateClassifier] Chromosome: " + chromosome + ", Weights: " + w);
        }
        AbstractGeneticDiscoveryHandler[] handlers = new AbstractGeneticDiscoveryHandler[this.m_Handlers.length];
        for (i = 0; i < handlers.length; ++i) {
            handlers[i] = (AbstractGeneticDiscoveryHandler)this.m_Handlers[i].shallowCopy();
        }
        Classifier result = (Classifier)OptionUtils.shallowCopy((Object)this.getClassifier());
        if (result == null) {
            this.getLogger().severe("Failed to copy classifier!");
            return null;
        }
        DefaultPropertyDiscovery discovery = new DefaultPropertyDiscovery();
        discovery.discover((AbstractDiscoveryHandler[])handlers, (Object)result);
        int pos = 0;
        for (AbstractGeneticDiscoveryHandler handler : handlers) {
            List conts = handler.getContainers();
            for (PropertyPath.PropertyContainer cont : conts) {
                String strArray = this.intArrayToString(this.getBitsForPosition(weights, this.m_start, this.m_numbits, pos));
                handler.unpack(cont, strArray);
                ++pos;
            }
        }
        return result;
    }

    public static class HermioneJob
    extends AbstractClassifierBasedGeneticAlgorithmWithSecondEvaluation.ClassifierBasedGeneticAlgorithmWithSecondEvaluationJob<Hermione> {
        private static final long serialVersionUID = 8259167463381721274L;

        public HermioneJob(Hermione g, int num, int[] w, Instances data, Instances testData) {
            super(g, num, w, data, testData);
        }

        @Override
        protected Map<String, Object> assembleSetup(double fitness, Classifier cls, int chromosome, int[] weights) {
            Map<String, Object> result = super.assembleSetup(fitness, cls, chromosome, weights);
            int pos = 0;
            AbstractGeneticDiscoveryHandler[] handlers = new AbstractGeneticDiscoveryHandler[((Hermione)this.getOwner()).getHandlers().length];
            for (int i = 0; i < ((Hermione)this.getOwner()).getHandlers().length; ++i) {
                handlers[i] = (AbstractGeneticDiscoveryHandler)((Hermione)this.getOwner()).getHandlers()[i].shallowCopy();
            }
            DefaultPropertyDiscovery discovery = new DefaultPropertyDiscovery();
            discovery.setLoggingLevel(this.getLoggingLevel());
            discovery.discover((AbstractDiscoveryHandler[])handlers, (Object)cls);
            List<Integer> numbits = ((Hermione)this.getOwner()).getNumBitsForAll(handlers);
            List<Integer> start = ((Hermione)this.getOwner()).getStartPoints(handlers);
            for (AbstractGeneticDiscoveryHandler handler : handlers) {
                List conts = handler.getContainers();
                for (PropertyPath.PropertyContainer cont : conts) {
                    String strArray = ((Hermione)this.getOwner()).intArrayToString(((Hermione)this.getOwner()).getBitsForPosition(weights, start, numbits, pos));
                    result.put("Weights." + pos, strArray);
                    ++pos;
                }
            }
            return result;
        }

        public void calcNewFitness() {
            block13: {
                String weightsStr = this.weightsToString();
                if (this.isLoggingEnabled()) {
                    this.getLogger().fine("calc for: " + weightsStr);
                }
                try {
                    Double measure = ((Hermione)this.getOwner()).getResult(weightsStr);
                    if (measure != null) {
                        if (this.isLoggingEnabled()) {
                            this.getLogger().info("Already present: " + measure);
                        }
                        this.m_Fitness = measure;
                        return;
                    }
                    Instances newInstances = new Instances(this.getInstances());
                    Instances newTest = null;
                    if (this.getTestInstances() != null) {
                        newTest = new Instances(this.getTestInstances());
                    }
                    Classifier newClassifier = ((Hermione)this.getOwner()).generateClassifier(this.m_Chromosome, this.m_Weights);
                    this.m_Fitness = newTest == null ? Double.valueOf(this.evaluateClassifier(newClassifier, newInstances, this.getFolds(), this.getSeed())) : Double.valueOf(this.evaluateClassifier(newClassifier, newInstances, newTest));
                    if (((Hermione)this.getOwner()).isBetterFitness(this.m_Fitness)) {
                        boolean canAdd = true;
                        if (this.getUseSecondEvaluation() && newTest == null) {
                            Classifier newSecondClassifier = ((Hermione)this.getOwner()).generateClassifier(this.m_Chromosome, this.m_Weights);
                            this.m_SecondFitness = this.evaluateClassifier(newSecondClassifier, newInstances, this.getSecondFolds(), this.getSecondSeed());
                            canAdd = ((Hermione)this.getOwner()).isSecondBetterFitness(this.m_SecondFitness);
                            if (((Hermione)this.getOwner()).setSecondNewFitness(this.m_SecondFitness, newSecondClassifier, this.m_Chromosome, this.m_Weights)) {
                                if (this.isLoggingEnabled()) {
                                    this.getLogger().info("Second evaluation is also better: " + this.m_SecondFitness);
                                }
                            } else if (this.isLoggingEnabled()) {
                                this.getLogger().info("Second evaluation is not better: " + this.m_SecondFitness);
                            }
                            ((Hermione)this.getOwner()).addSecondResult(weightsStr, this.m_SecondFitness);
                        }
                        if (canAdd && ((Hermione)this.getOwner()).setNewFitness(this.m_Fitness, newClassifier, this.m_Chromosome, this.m_Weights)) {
                            this.generateOutput(this.m_Fitness, newInstances, newClassifier, this.m_Chromosome, this.m_Weights);
                            ((Hermione)this.getOwner()).notifyFitnessChangeListeners(this.getMeasure().adjust(this.m_Fitness), newClassifier, this.m_Weights);
                        }
                    }
                    ((Hermione)this.getOwner()).addResult(weightsStr, this.m_Fitness);
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Error: ", (Throwable)e);
                    this.m_Fitness = null;
                    if (!this.getUseSecondEvaluation()) break block13;
                    this.m_SecondFitness = null;
                }
            }
        }
    }
}

