/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import adams.data.binning.Binnable;
import adams.data.binning.BinnableInstances;
import adams.data.splitgenerator.generic.randomization.DefaultRandomization;
import adams.data.splitgenerator.generic.randomization.PassThrough;
import adams.data.splitgenerator.generic.randomization.Randomization;
import adams.data.splitgenerator.generic.randomsplit.SplitPair;
import adams.data.splitgenerator.generic.splitter.DefaultSplitter;
import adams.data.splitgenerator.generic.splitter.Splitter;
import adams.flow.container.WekaTrainTestSetContainer;
import java.util.List;
import weka.classifiers.AbstractSplitGenerator;
import weka.classifiers.RandomSplitGenerator;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.InstancesView;

public class DefaultRandomSplitGenerator
extends AbstractSplitGenerator
implements RandomSplitGenerator {
    private static final long serialVersionUID = -4813006743965500489L;
    protected double m_Percentage;
    protected boolean m_PreserveOrder;
    protected boolean m_Generated;
    protected adams.data.splitgenerator.generic.randomsplit.RandomSplitGenerator m_Generator;

    public DefaultRandomSplitGenerator() {
    }

    public DefaultRandomSplitGenerator(Instances data, long seed, double percentage) {
        this.setData(data);
        this.setSeed(seed);
        this.setPercentage(percentage);
        this.setPreserveOrder(false);
    }

    public DefaultRandomSplitGenerator(Instances data, double percentage) {
        this.setData(data);
        this.setSeed(-1L);
        this.setPercentage(percentage);
        this.setPreserveOrder(true);
    }

    public DefaultRandomSplitGenerator(Instances data, long seed, double percentage, boolean preserveOrder) {
        this.setData(data);
        this.setSeed(seed);
        this.setPercentage(percentage);
        this.setPreserveOrder(preserveOrder);
    }

    public String globalInfo() {
        return "Performs a percentage split, either randomized or with the order preserved.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("percentage", "percentage", (Object)0.66, (Number)0.0, (Number)1.0);
        this.m_OptionManager.add("preserve-order", "preserveOrder", (Object)false);
    }

    @Override
    public void setPercentage(double value) {
        if (this.getOptionManager().isValid("percentage", (Number)value)) {
            this.m_Percentage = value;
            this.reset();
        }
    }

    @Override
    public double getPercentage() {
        return this.m_Percentage;
    }

    public String percentageTipText() {
        return "The percentage to use for training (0-1).";
    }

    @Override
    public void setPreserveOrder(boolean value) {
        this.m_PreserveOrder = value;
        this.reset();
    }

    @Override
    public boolean getPreserveOrder() {
        return this.m_PreserveOrder;
    }

    public String preserveOrderTipText() {
        return "If enabled, the order in the data is preserved in the split.";
    }

    @Override
    protected boolean canRandomize() {
        return !this.m_PreserveOrder;
    }

    @Override
    protected void doInitializeIterator() {
        DefaultRandomization rand;
        if (this.m_Data == null) {
            throw new IllegalStateException("No data available!");
        }
        this.m_Generator = new adams.data.splitgenerator.generic.randomsplit.RandomSplitGenerator();
        if (this.canRandomize()) {
            rand = new DefaultRandomization();
            rand.setSeed(this.m_Seed);
            this.m_Generator.setRandomization((Randomization)rand);
        } else {
            rand = new PassThrough();
            this.m_Generator.setRandomization((Randomization)rand);
        }
        DefaultSplitter splitter = new DefaultSplitter();
        splitter.setPercentage(this.m_Percentage);
        this.m_Generator.setSplitter((Splitter)splitter);
        this.m_Generated = false;
    }

    @Override
    protected boolean checkNext() {
        return !this.m_Generated;
    }

    @Override
    protected WekaTrainTestSetContainer createNext() {
        Instances testSet;
        Instances trainSet;
        List<Binnable<Instance>> binnableInst;
        this.m_Generated = true;
        try {
            binnableInst = BinnableInstances.toBinnableUsingIndex(this.m_Data);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create binnable Instances!", e);
        }
        SplitPair splitPair = this.m_Generator.generate(binnableInst);
        int[] trainRows = splitPair.getTrain().getOriginalIndices().toArray();
        int[] testRows = splitPair.getTest().getOriginalIndices().toArray();
        if (this.m_UseViews) {
            trainSet = new InstancesView(this.m_Data, trainRows);
            testSet = new InstancesView(this.m_Data, testRows);
        } else {
            trainSet = BinnableInstances.toInstances(splitPair.getTrain().getData());
            testSet = BinnableInstances.toInstances(splitPair.getTest().getData());
        }
        WekaTrainTestSetContainer result = new WekaTrainTestSetContainer(trainSet, testSet, this.m_Seed, null, null, trainRows, testRows);
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + ", percentage=" + this.m_Percentage;
    }
}

