/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import adams.data.statistics.StatUtils;
import java.util.Arrays;
import java.util.List;
import weka.classifiers.evaluation.AbstractSimpleRegressionMeasure;
import weka.core.Utils;

public class MSLE
extends AbstractSimpleRegressionMeasure {
    private static final long serialVersionUID = 6501729731780442367L;
    public static final String NAME = "Mean squared logarithmic error";
    public static final double EPSILON = 1.0E-5;

    public String getMetricName() {
        return NAME;
    }

    public String getMetricDescription() {
        return NAME;
    }

    public List<String> getStatisticNames() {
        return Arrays.asList(NAME);
    }

    protected double clip(double value) {
        if (value < 1.0E-5) {
            return 1.0E-5;
        }
        return value;
    }

    public double getStatistic(String statName) {
        if (statName.equals(NAME)) {
            if (this.m_Actual.size() == 0) {
                return Utils.missingValue();
            }
            if (this.m_Actual.min() < 1.0E-5) {
                return Utils.missingValue();
            }
            double logMeanY = Math.log(StatUtils.mean((double[])this.m_Actual.toArray()));
            double sum = 0.0;
            for (int i = 0; i < this.m_Actual.size(); ++i) {
                sum += Math.pow(logMeanY - Math.log(this.clip(this.m_Predicted.get(i))), 2.0);
            }
            return sum / (double)this.m_Actual.size();
        }
        return Utils.missingValue();
    }

    public String toSummaryString() {
        return Utils.padRight((String)NAME, (int)41) + Utils.doubleToString((double)this.getStatistic(NAME), (int)4) + "\n";
    }
}

