/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import adams.data.statistics.StatUtils;
import java.util.Arrays;
import java.util.List;
import weka.classifiers.evaluation.AbstractSimpleRegressionMeasure;
import weka.core.Utils;

public class RPD
extends AbstractSimpleRegressionMeasure {
    private static final long serialVersionUID = -2991979775999208848L;
    public static final String NAME = "Ratio of Performance to Deviation";

    public String getMetricName() {
        return NAME;
    }

    public String getMetricDescription() {
        return "Ratio of Performance to Deviation = SD / RMSE";
    }

    public List<String> getStatisticNames() {
        return Arrays.asList(NAME);
    }

    public double getStatistic(String statName) {
        if (statName.equals(NAME)) {
            if (this.m_Actual.size() == 0) {
                return Utils.missingValue();
            }
            double rmse = StatUtils.rmse((double[])this.m_Actual.toArray(), (double[])this.m_Predicted.toArray());
            double sd = StatUtils.stddev((double[])this.m_Predicted.toArray(), (boolean)true);
            return sd / rmse;
        }
        return Utils.missingValue();
    }

    public String toSummaryString() {
        return Utils.padRight((String)NAME, (int)41) + Utils.doubleToString((double)this.getStatistic(NAME), (int)4) + "\n";
    }
}

