/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import adams.core.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.SingleClassifierEnhancer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.Resample;

public class LeastMedianSq
extends SingleClassifierEnhancer
implements WeightedInstancesHandler {
    private static final long serialVersionUID = -2767224971510964983L;
    protected double[] m_Residuals;
    protected double[] m_weight;
    protected double m_SSR;
    protected double m_scalefactor;
    protected double m_bestMedian = Double.POSITIVE_INFINITY;
    protected double m_Ridge = 1.0;
    protected Classifier m_currentClassifier;
    protected Classifier m_bestClassifier;
    protected Instances m_Data;
    protected Instances m_SubSample;
    protected int m_numreg = 10;
    protected int m_instancepct = 80;
    protected int m_errPct = 50;
    protected boolean m_debug = false;
    protected Random m_random;
    protected long m_randomseed = 0L;

    public String globalInfo() {
        return "Finds the base classifier with the best least median squared error.";
    }

    public Enumeration listOptions() {
        Vector newVector = new Vector();
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        newVector.addElement(new Option("\tNumber of regressions\n\t(default: 10)\n", "S", 1, "-S <sint>"));
        newVector.addElement(new Option("\tPercent sample size\n\t(default: 60)\n", "P", 1, "-P <int>"));
        newVector.addElement(new Option("\tPercent Error at\n\t(default: 50)\n", "E", 1, "-E <int>"));
        newVector.addElement(new Option("\tSet the seed used to generate samples\n\t(default: 0)\n", "G", 1, "-G <seed>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String curropt = weka.core.Utils.getOption((char)'S', (String[])options);
        if (curropt.length() != 0) {
            this.setNumRegressions(Integer.parseInt(curropt));
        } else {
            this.setNumRegressions(10);
        }
        curropt = weka.core.Utils.getOption((char)'P', (String[])options);
        if (curropt.length() != 0) {
            this.setPct(Integer.parseInt(curropt));
        } else {
            this.setPct(80);
        }
        curropt = weka.core.Utils.getOption((char)'E', (String[])options);
        if (curropt.length() != 0) {
            this.setError(Integer.parseInt(curropt));
        } else {
            this.setError(50);
        }
        curropt = weka.core.Utils.getOption((char)'G', (String[])options);
        if (curropt.length() != 0) {
            this.setRandomSeed(Long.parseLong(curropt));
        } else {
            this.setRandomSeed(0L);
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        String[] options;
        ArrayList<String> result = new ArrayList<String>();
        result.add("-S");
        result.add("" + this.getNumRegressions());
        result.add("-P");
        result.add("" + this.getPct());
        result.add("-E");
        result.add("" + this.getError());
        result.add("-G");
        result.add("" + this.getRandomSeed());
        for (String option : options = super.getOptions()) {
            result.add(option);
        }
        return result.toArray(new String[result.size()]);
    }

    protected void findResiduals() throws Exception {
        this.m_SSR = 0.0;
        this.m_Residuals = new double[this.m_Data.numInstances()];
        for (int i = 0; i < this.m_Data.numInstances(); ++i) {
            this.m_Residuals[i] = this.m_currentClassifier.classifyInstance(this.m_Data.instance(i));
            int n = i;
            this.m_Residuals[n] = this.m_Residuals[n] - this.m_Data.instance(i).value(this.m_Data.classAttribute());
            int n2 = i;
            this.m_Residuals[n2] = this.m_Residuals[n2] * this.m_Residuals[i];
            this.m_SSR += this.m_Residuals[i];
        }
    }

    protected void getErrorAtPct(int pct) throws Exception {
        this.findResiduals();
        Vector<Double> v = new Vector<Double>();
        for (int i = 0; i < this.m_Residuals.length; ++i) {
            v.add(this.m_Residuals[i]);
        }
        Collections.sort(v);
        int p = this.m_Residuals.length;
        int pos = (int)((double)p * (double)pct / 100.0);
        if (this.m_debug) {
            System.err.println("pos=" + pos + "   residual:" + v.get(pos));
        }
        if ((Double)v.get(pos) < this.m_bestMedian) {
            if (this.m_debug) {
                System.err.println("+++ pos=" + pos + "   new best residual:" + v.get(pos));
            }
            this.m_bestMedian = (Double)v.get(pos);
            this.m_bestClassifier = this.m_currentClassifier;
        }
    }

    protected void findBestRegression() throws Exception {
        Random rn = new Random(this.getRandomSeed());
        this.m_bestMedian = Double.POSITIVE_INFINITY;
        if (this.m_debug) {
            System.out.println("Starting:");
        }
        int s = 0;
        int r = 0;
        while (s < this.m_numreg) {
            if (this.m_debug) {
                System.out.print("*");
            }
            this.genRegression(rn);
            this.getErrorAtPct(this.getError());
            ++s;
            ++r;
        }
        if (this.m_debug) {
            // empty if block
        }
        this.m_Classifier = this.m_bestClassifier;
    }

    protected void selectSubSample(Instances data, Random r) throws Exception {
        Resample f = new Resample();
        f.setRandomSeed(r.nextInt());
        f.setSampleSizePercent((double)this.m_instancepct);
        f.setInputFormat(data);
        f.setNoReplacement(true);
        this.m_SubSample = Filter.useFilter((Instances)data, (Filter)f);
    }

    protected void genRegression(Random r) throws Exception {
        this.m_currentClassifier = (Classifier)Utils.deepCopy((Object)this.m_Classifier);
        this.selectSubSample(this.m_Data, r);
        this.m_currentClassifier.buildClassifier(this.m_SubSample);
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.setMinimumNumberInstances(1);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_Data = new Instances(data);
        this.m_Data.deleteWithMissingClass();
        this.findBestRegression();
    }

    public double classifyInstance(Instance inst) throws Exception {
        return this.m_Classifier.classifyInstance(inst);
    }

    public String toString() {
        return this.m_Classifier.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public String numRegressionsTipText() {
        return "Set the size of the random samples used to generate the least sqaured regression functions.";
    }

    public void setPct(int pct) {
        this.m_instancepct = pct;
    }

    public int getPct() {
        return this.m_instancepct;
    }

    public String pctTipText() {
        return "pct instances for regression";
    }

    public void setError(int pct) {
        this.m_errPct = pct;
    }

    public int getError() {
        return this.m_errPct;
    }

    public String errorTipText() {
        return "pct pos to get error for comparison. e.g 50=median. 75=upper quartile";
    }

    public void setNumRegressions(int samplesize) {
        this.m_numreg = samplesize;
    }

    public int getNumRegressions() {
        return this.m_numreg;
    }

    public String randomSeedTipText() {
        return "Set the seed for selecting random subsamples of the training data.";
    }

    public void setRandomSeed(long randomseed) {
        this.m_randomseed = randomseed;
    }

    public long getRandomSeed() {
        return this.m_randomseed;
    }

    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    public boolean getDebug() {
        return this.m_debug;
    }

    public static void main(String[] argv) {
        LeastMedianSq.runClassifier((Classifier)new LeastMedianSq(), (String[])argv);
    }
}

