/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import adams.core.base.BaseRegExp;
import adams.core.logging.LoggingObject;
import adams.data.weka.WekaAttributeIndex;
import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.InstancesView;

public class InstanceGrouping
extends LoggingObject {
    private static final long serialVersionUID = 7047752529464358361L;
    protected Instances m_Data;
    protected WekaAttributeIndex m_Index;
    protected BaseRegExp m_RegExp;
    protected String m_Group;
    protected Map<String, TIntList> m_Groups;

    public InstanceGrouping(Instances data, WekaAttributeIndex index, BaseRegExp regExp, String group) {
        this.m_Data = new Instances(data);
        this.m_RegExp = regExp;
        this.m_Index = index;
        this.m_Group = group;
        this.initialize();
        this.process();
    }

    protected void initialize() {
        this.m_Groups = new HashMap<String, TIntList>();
        if (this.m_Data == null) {
            throw new IllegalArgumentException("No data provided!");
        }
        this.m_Index.setData(this.m_Data);
        int col = this.m_Index.getIntIndex();
        if (col == -1) {
            throw new IllegalArgumentException("Failed to locate attribute using index: " + this.m_Index.getIndex());
        }
        if (!this.m_Data.attribute(col).isNominal() && !this.m_Data.attribute(col).isString()) {
            throw new IllegalArgumentException("Attribute '" + this.m_Index.getIndex() + "' can only be nominal or string, found: " + Attribute.typeToString((int)this.m_Data.attribute(col).type()));
        }
        if (this.m_Group.isEmpty()) {
            throw new IllegalArgumentException("No replacement string provided to from the groups!");
        }
    }

    protected void process() {
        int col = this.m_Index.getIntIndex();
        for (int i = 0; i < this.m_Data.numInstances(); ++i) {
            Instance inst = this.m_Data.instance(i);
            String id = inst.stringValue(col);
            String group = id.replaceAll(this.m_RegExp.getValue(), this.m_Group);
            if (!this.m_Groups.containsKey(group)) {
                this.m_Groups.put(group, (TIntList)new TIntArrayList());
            }
            this.m_Groups.get(group).add(i);
        }
    }

    protected Instances collapsedHeader() {
        int col = this.m_Index.getIntIndex();
        ArrayList<String> groups = new ArrayList<String>(this.m_Groups.keySet());
        Collections.sort(groups);
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        Attribute att = this.m_Data.attribute(col);
        boolean nominal = att.isNominal();
        if (nominal) {
            atts.add(new Attribute(att.name(), groups));
        } else {
            atts.add(new Attribute(att.name(), (List)null));
        }
        if (this.m_Data.classIndex() != -1) {
            atts.add((Attribute)this.m_Data.classAttribute().copy());
        }
        Instances result = new Instances(this.m_Data.relationName(), atts, this.size());
        if (this.m_Data.classIndex() != -1) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    public Instances collapse(Instances data) {
        Instances result = this.collapsedHeader();
        boolean nominal = result.attribute(0).isNominal();
        int col = this.m_Index.getIntIndex();
        HashSet<String> added = new HashSet<String>();
        for (int i = 0; i < data.numInstances(); ++i) {
            Instance inst = data.instance(i);
            String id = inst.stringValue(col);
            String group = id.replaceAll(this.m_RegExp.getValue(), this.m_Group);
            if (!this.m_Groups.containsKey(group)) {
                throw new IllegalStateException("Unknown group generated from instance #" + (i + 1) + " using '" + id + "': " + group);
            }
            if (added.contains(group)) continue;
            double[] values = new double[result.classIndex() != -1 ? 2 : 1];
            values[0] = nominal ? (double)result.attribute(0).indexOfValue(group) : (double)result.attribute(0).addStringValue(group);
            if (result.classIndex() != -1) {
                values[1] = inst.classValue();
            }
            result.add((Instance)new DenseInstance(inst.weight(), values));
            added.add(group);
        }
        result.compactify();
        return result;
    }

    protected void expandCheck(Instances data) {
        if (this.m_Data.classIndex() != -1) {
            if (data.numAttributes() != 2) {
                throw new IllegalArgumentException("Expected dataset with two attributes, but got: " + data.numAttributes());
            }
        } else if (data.numAttributes() != 1) {
            throw new IllegalArgumentException("Expected dataset with one attribute, but got: " + data.numAttributes());
        }
        if (!data.attribute(0).isNominal() && !data.attribute(0).isString()) {
            throw new IllegalArgumentException("First attribute is neither nominal nor string: " + Attribute.typeToString((int)data.attribute(0).type()));
        }
    }

    public TIntList expand(Instances data, TIntList subset) {
        this.expandCheck(data);
        TIntArrayList result = new TIntArrayList();
        for (int i = 0; i < subset.size(); ++i) {
            Instance inst = data.instance(subset.get(i));
            String group = inst.stringValue(0);
            if (!this.m_Groups.containsKey(group)) {
                throw new IllegalStateException("Unknown group: " + group);
            }
            TIntList members = this.m_Groups.get(group);
            result.addAll((TIntCollection)members);
        }
        return result;
    }

    public Instances expand(Instances data, boolean useView) {
        InstancesView result;
        int i;
        this.expandCheck(data);
        TIntArrayList expanded = new TIntArrayList();
        for (i = 0; i < data.numInstances(); ++i) {
            Instance inst = data.instance(i);
            String group = inst.stringValue(0);
            if (!this.m_Groups.containsKey(group)) {
                throw new IllegalStateException("Unknown group: " + group);
            }
            TIntList members = this.m_Groups.get(group);
            expanded.addAll((TIntCollection)members);
        }
        if (useView) {
            result = new InstancesView(this.m_Data, expanded.toArray());
        } else {
            result = new Instances(this.m_Data, expanded.size());
            for (i = 0; i < expanded.size(); ++i) {
                result.add((Instance)this.m_Data.instance(expanded.get(i)).copy());
            }
        }
        return result;
    }

    public Instances getData() {
        return this.m_Data;
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String getGroup() {
        return this.m_Group;
    }

    public int size() {
        return this.m_Groups.size();
    }

    public Set<String> groups() {
        return this.m_Groups.keySet();
    }

    public TIntList get(String group) {
        return this.m_Groups.get(group);
    }

    public String toString() {
        return "" + this.m_Groups;
    }
}

