/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import adams.core.option.OptionUtils;
import adams.data.conversion.WekaInstancesToSpreadSheet;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;

public class SpreadSheetSaver
extends AbstractFileSaver
implements BatchConverter {
    private static final long serialVersionUID = -6155802217430401683L;
    protected SpreadSheetWriter m_Writer = new CsvSpreadSheetWriter();
    protected File m_OutputFile;

    public SpreadSheetSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes the Instances to a spreadsheet file using the specified ADAMS spreadsheet writer.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement((Option)en.nextElement());
        }
        result.addElement(new Option("\tThe writer to use).\n\t(default: " + CsvSpreadSheetWriter.class.getName() + ")", "writer", 1, "-writer <classname + options>"));
        return result.elements();
    }

    public void resetOptions() {
        super.resetOptions();
        this.m_Writer = new CsvSpreadSheetWriter();
        this.m_OutputFile = null;
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-writer");
        result.add(OptionUtils.getCommandLine((Object)this.getSpreadSheetWriter()));
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption((String)"writer", (String[])options);
        if (tmpStr.length() != 0) {
            this.setSpreadSheetWriter((SpreadSheetWriter)OptionUtils.forAnyCommandLine(SpreadSheetWriter.class, (String)tmpStr));
        } else {
            this.setSpreadSheetWriter((SpreadSheetWriter)new CsvSpreadSheetWriter());
        }
    }

    public String getFileDescription() {
        return "ADAMS Spreadsheets";
    }

    public String getFileExtension() {
        return this.getFileExtensions()[0];
    }

    public String[] getFileExtensions() {
        String[] result = this.m_Writer.getFormatExtensions();
        for (int i = 0; i < result.length; ++i) {
            if (result[i].startsWith(".")) continue;
            result[i] = "." + result[i];
        }
        return result;
    }

    public void setSpreadSheetWriter(SpreadSheetWriter value) {
        this.m_Writer = value;
    }

    public SpreadSheetWriter getSpreadSheetWriter() {
        return this.m_Writer;
    }

    public String spreadSheetWriterTipText() {
        return "The ADAMS spreadsheet writer to use for outputting the data.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public void setDestination(File file) throws IOException {
        this.m_OutputFile = file;
    }

    public void setDestination(OutputStream output) throws IOException {
        throw new IOException("Writing to an outputstream not supported");
    }

    public void writeBatch() throws IOException {
        if (this.getInstances() == null) {
            throw new IOException("No instances to save!");
        }
        if (this.m_OutputFile == null) {
            throw new IOException("No output file set!");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        WekaInstancesToSpreadSheet conversion = new WekaInstancesToSpreadSheet();
        conversion.setInput(this.getInstances());
        String msg = conversion.convert();
        if (msg != null) {
            throw new IOException("Conversion from Instances to SpreadSheet failed: " + msg);
        }
        SpreadSheet sheet = (SpreadSheet)conversion.getOutput();
        conversion.cleanUp();
        if (!this.m_Writer.write(sheet, this.m_OutputFile)) {
            throw new IOException("Failed writing data to '" + this.m_OutputFile + "'!");
        }
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        SpreadSheetSaver.runFileSaver((AbstractFileSaver)new SpreadSheetSaver(), (String[])args);
    }
}

