/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.option.OptionUtils;
import adams.gui.tools.wekamultiexperimenter.experiment.ExperimentWithCustomizableRelationNames;
import java.io.File;
import javax.swing.DefaultListModel;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.experiment.Experiment;
import weka.experiment.PropertyNode;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;

public class ExtExperiment
extends Experiment
implements ExperimentWithCustomizableRelationNames {
    private static final long serialVersionUID = 6600722909231586798L;
    protected boolean m_UseFilename = false;
    protected boolean m_PrefixDatasetsWithIndex = false;

    public ExtExperiment() {
    }

    public ExtExperiment(Experiment exp) {
        this.assign(exp);
    }

    public void assign(Experiment exp) {
        this.m_ResultListener = (ResultListener)OptionUtils.shallowCopy((Object)exp.getResultListener());
        this.m_ResultProducer = (ResultProducer)OptionUtils.shallowCopy((Object)exp.getResultProducer());
        this.m_RunLower = exp.getRunLower();
        this.m_RunUpper = exp.getRunUpper();
        this.m_Datasets = new DefaultListModel();
        for (int i = 0; i < exp.getDatasets().size(); ++i) {
            this.m_Datasets.addElement(exp.getDatasets().get(i));
        }
        this.m_UsePropertyIterator = exp.getUsePropertyIterator();
        this.m_PropertyPath = null;
        if (exp.getPropertyPath() != null) {
            this.m_PropertyPath = (PropertyNode[])Utils.deepCopy((Object)exp.getPropertyPath());
        }
        this.m_PropertyArray = null;
        if (exp.getPropertyArray() != null) {
            this.m_PropertyArray = Utils.deepCopy((Object)exp.getPropertyArray());
        }
        this.m_Notes = exp.getNotes();
        this.m_AdditionalMeasures = null;
        this.m_ClassFirst = exp.m_ClassFirst;
        this.m_AdvanceDataSetFirst = exp.getAdvanceDataSetFirst();
    }

    public boolean isClassFirst() {
        return this.m_ClassFirst;
    }

    @Override
    public void setUseFilename(boolean value) {
        this.m_UseFilename = value;
    }

    @Override
    public boolean getUseFilename() {
        return this.m_UseFilename;
    }

    @Override
    public void setPrefixDatasetsWithIndex(boolean value) {
        this.m_PrefixDatasetsWithIndex = value;
    }

    @Override
    public boolean getPrefixDatasetsWithIndex() {
        return this.m_PrefixDatasetsWithIndex;
    }

    public void nextIteration() throws Exception {
        if (this.m_UsePropertyIterator && this.m_CurrentProperty != this.m_PropertyNumber) {
            this.setProperty(0, this.m_ResultProducer);
            this.m_CurrentProperty = this.m_PropertyNumber;
        }
        if (this.m_CurrentInstances == null) {
            File currentFile = (File)this.getDatasets().elementAt(this.m_DatasetNumber);
            AbstractFileLoader loader = ConverterUtils.getLoaderForFile((File)currentFile);
            loader.setFile(currentFile);
            Instances data = new Instances(loader.getDataSet());
            if (data.classIndex() == -1) {
                if (this.m_ClassFirst) {
                    data.setClassIndex(0);
                } else {
                    data.setClassIndex(data.numAttributes() - 1);
                }
            }
            if (this.m_UseFilename) {
                data.setRelationName(FileUtils.replaceExtension((File)currentFile, (String)"").getName());
            }
            if (this.m_PrefixDatasetsWithIndex) {
                data.setRelationName(this.m_DatasetNumber + 1 + ":" + data.relationName());
            }
            this.m_CurrentInstances = data;
            this.m_ResultProducer.setInstances(this.m_CurrentInstances);
        }
        this.m_ResultProducer.doRun(this.m_RunNumber);
        this.advanceCounters();
    }
}

