/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import adams.core.SerializationHelper;
import adams.core.io.PlaceholderFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;

public class SerializedFilter
extends SimpleBatchFilter {
    private static final long serialVersionUID = 4204884126927666844L;
    protected PlaceholderFile m_Serialized = new PlaceholderFile();
    protected Filter m_ActualFilter;

    public String globalInfo() {
        return "Processes the data with a the (trained) filter deserialized from the specified file.";
    }

    protected void reset() {
        super.reset();
        this.m_ActualFilter = null;
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        result.addElement(new Option("\tThe serialized filter file.\n\t(default: .)", "serialized", 1, "-serialized <file>"));
        return result.elements();
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        result.add("-serialized");
        result.add("" + this.getSerialized());
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption((String)"serialized", (String[])options);
        if (tmpStr.length() != 0) {
            this.setSerialized(new PlaceholderFile(tmpStr));
        } else {
            this.setSerialized(new PlaceholderFile());
        }
    }

    public void setSerialized(PlaceholderFile value) {
        this.m_Serialized = value;
        this.reset();
    }

    public PlaceholderFile getSerialized() {
        return this.m_Serialized;
    }

    public String serializedTipText() {
        return "The file containing the (trained) serialized filter.";
    }

    protected synchronized Filter getActualFilter() {
        if (this.m_ActualFilter == null) {
            if (!this.m_Serialized.exists()) {
                return null;
            }
            if (this.m_Serialized.isDirectory()) {
                return null;
            }
            try {
                this.m_ActualFilter = (Filter)SerializationHelper.read((String)this.m_Serialized.getAbsolutePath());
            }
            catch (Exception e) {
                System.err.println(((Object)((Object)this)).getClass().getName() + ": Failed to load serialized filter from " + this.m_Serialized);
                e.printStackTrace();
                return null;
            }
        }
        return this.m_ActualFilter;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        if (this.getActualFilter() != null) {
            return this.getActualFilter().getOutputFormat();
        }
        return new Instances(inputFormat, 0);
    }

    public Capabilities getCapabilities() {
        if (this.getActualFilter() != null) {
            return this.getActualFilter().getCapabilities();
        }
        return super.getCapabilities();
    }

    protected Instances process(Instances instances) throws Exception {
        if (this.getActualFilter() != null) {
            return Filter.useFilter((Instances)instances, (Filter)this.getActualFilter());
        }
        throw new IllegalStateException("No serialized filter loaded!");
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        SerializedFilter.runFilter((Filter)new SerializedFilter(), (String[])args);
    }
}

