/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.VariableName;
import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.condition.test.FileExists;
import adams.flow.condition.test.TestCondition;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.source.StringConstants;
import adams.flow.source.WekaClassifierSetup;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.ConditionalTransformer;
import adams.flow.transformer.SetVariable;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaCrossValidationEvaluator;
import adams.flow.transformer.WekaEvaluationSummary;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;

public class ConditionalTransformerTest
extends AbstractFlowTest {
    public ConditionalTransformerTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.copyResourceToTmp("labor.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("labor.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public Actor getActor() {
        WekaClassifierSetup cls = new WekaClassifierSetup();
        cls.setName("cls");
        cls.setClassifier((Classifier)new J48());
        CallableActors ga = new CallableActors();
        ga.setActors(new Actor[]{cls});
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("${TMP}/vote.arff"), new BaseString("${TMP}/labor.arff")});
        SetVariable sv = new SetVariable();
        sv.setVariableName(new VariableName("filename"));
        WekaFileReader fr = new WekaFileReader();
        FileExists fe = new FileExists();
        fe.getOptionManager().setVariableForProperty("file", "filename");
        ConditionalTransformer ctrans = new ConditionalTransformer();
        ctrans.setCondition((TestCondition)fe);
        ctrans.setActor((Actor)fr);
        ctrans.setCheckAtExecutionTime(true);
        WekaClassSelector cs = new WekaClassSelector();
        WekaCrossValidationEvaluator cv = new WekaCrossValidationEvaluator();
        cv.setClassifier(new CallableActorReference("cls"));
        WekaEvaluationSummary eval = new WekaEvaluationSummary();
        eval.setOutputRelationName(true);
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new Actor[]{ga, sc, sv, ctrans, cs, cv, eval, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(ConditionalTransformerTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ConditionalTransformerTest.runTest((Test)ConditionalTransformerTest.suite());
    }
}

