/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.weka.evaluator.AbstractInstanceEvaluator;
import adams.data.weka.evaluator.IntervalEstimatorBased;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorReference;
import adams.flow.source.FileSupplier;
import adams.flow.source.SequenceSource;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaInstanceDumper;
import adams.flow.transformer.WekaInstanceEvaluator;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.Classifier;
import weka.classifiers.functions.GaussianProcessesNoWeights;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.RBFKernel;

public class WekaInstanceEvaluatorTest
extends AbstractFlowTest {
    public WekaInstanceEvaluatorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
        super.tearDown();
    }

    public Actor getActor() {
        FileSupplier sfsTrain = new FileSupplier();
        sfsTrain.setFiles(new PlaceholderFile[]{new TmpFile("bolts.arff")});
        WekaFileReader frTrain = new WekaFileReader();
        WekaClassSelector csTrain = new WekaClassSelector();
        SequenceSource seqs = new SequenceSource();
        seqs.setName("train");
        seqs.setActors(new Actor[]{sfsTrain, frTrain, csTrain});
        CallableActors ga = new CallableActors();
        ga.setActors(new Actor[]{seqs});
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("bolts.arff")});
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.INCREMENTAL);
        WekaClassSelector cs = new WekaClassSelector();
        GaussianProcessesNoWeights gp = new GaussianProcessesNoWeights();
        gp.setKernel((Kernel)new RBFKernel());
        gp.setNoise(0.01);
        IntervalEstimatorBased ieb = new IntervalEstimatorBased();
        ieb.setClassifier((Classifier)gp);
        WekaInstanceEvaluator eval = new WekaInstanceEvaluator();
        eval.setEvaluator((AbstractInstanceEvaluator)ieb);
        eval.setInstancesActor(new CallableActorReference("train"));
        WekaInstanceDumper id = new WekaInstanceDumper();
        id.setOutputPrefix((PlaceholderFile)new TmpFile("dumpfile"));
        Flow flow = new Flow();
        flow.setActors(new Actor[]{ga, sfs, fr, cs, eval, id});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.arff"));
    }

    public static Test suite() {
        return new TestSuite(WekaInstanceEvaluatorTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaInstanceEvaluatorTest.runTest((Test)WekaInstanceEvaluatorTest.suite());
    }
}

