/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import adams.env.Environment;
import adams.test.AdamsTestCase;
import java.util.ArrayList;
import weka.core.AbstractHashableInstance;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SerializedObject;
import weka.core.SparseInstance;
import weka.core.TestInstances;
import weka.test.AdamsTestHelper;

public abstract class AbstractHashableInstanceTestCase
extends AdamsTestCase {
    public AbstractHashableInstanceTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        Environment.setEnvironmentClass(Environment.class);
        super.setUp();
    }

    protected abstract AbstractHashableInstance wrap(Instance var1, boolean var2, boolean var3);

    protected void checkHashStaysSame(Instance dense, Instance sparse) {
        AbstractHashableInstanceTestCase.assertEquals((String)"hashcode differs", (int)this.wrap(dense, false, false).hashCode(), (int)this.wrap(sparse, false, false).hashCode());
        AbstractHashableInstanceTestCase.assertEquals((String)"hashcode differs (no class)", (int)this.wrap(dense, true, false).hashCode(), (int)this.wrap(sparse, true, false).hashCode());
        AbstractHashableInstanceTestCase.assertEquals((String)"hashcode differs (no weight)", (int)this.wrap(dense, false, true).hashCode(), (int)this.wrap(sparse, false, true).hashCode());
        AbstractHashableInstanceTestCase.assertEquals((String)"hashcode differs (no class+weight)", (int)this.wrap(dense, true, true).hashCode(), (int)this.wrap(sparse, true, true).hashCode());
        AbstractHashableInstanceTestCase.assertEquals((String)"hashcode differs (copy dense)", (int)this.wrap(dense, false, false).hashCode(), (int)this.wrap(dense, false, false).copy().hashCode());
        AbstractHashableInstanceTestCase.assertEquals((String)"hashcode differs (copy dense, no class)", (int)this.wrap(dense, true, false).hashCode(), (int)this.wrap(dense, true, false).copy().hashCode());
        AbstractHashableInstanceTestCase.assertEquals((String)"hashcode differs (copy dense, no weight)", (int)this.wrap(dense, false, true).hashCode(), (int)this.wrap(dense, false, true).copy().hashCode());
        AbstractHashableInstanceTestCase.assertEquals((String)"hashcode differs (copy dense, no class, no weight)", (int)this.wrap(dense, true, true).hashCode(), (int)this.wrap(dense, true, true).copy().hashCode());
        AbstractHashableInstanceTestCase.assertEquals((String)"hashcode differs (copy sparse, no class)", (int)this.wrap(sparse, true, false).hashCode(), (int)this.wrap(sparse, true, false).copy().hashCode());
        AbstractHashableInstanceTestCase.assertEquals((String)"hashcode differs (copy sparse, no weight)", (int)this.wrap(sparse, false, true).hashCode(), (int)this.wrap(sparse, false, true).copy().hashCode());
        AbstractHashableInstanceTestCase.assertEquals((String)"hashcode differs (copy sparse, no class, no weight)", (int)this.wrap(sparse, true, true).hashCode(), (int)this.wrap(sparse, true, true).copy().hashCode());
    }

    public void testHashStaysSame() {
        int i;
        double[] values = new double[]{1.0, 2.0, 3.0, 4.0, 0.0};
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (i = 0; i < values.length; ++i) {
            atts.add(new Attribute("" + i));
        }
        Instances data = new Instances("test", atts, 0);
        DenseInstance dense = new DenseInstance(1.0, values);
        dense.setDataset(data);
        SparseInstance sparse = new SparseInstance(1.0, values);
        sparse.setDataset(data);
        this.checkHashStaysSame((Instance)dense, (Instance)sparse);
        TestInstances test = new TestInstances();
        test.setNumClasses(3);
        test.setNumInstances(10);
        test.setNumDate(2);
        test.setNumNominal(2);
        test.setNumNumeric(2);
        test.setNumString(2);
        test.setNumRelational(2);
        test.setNumRelationalDate(2);
        test.setNumRelationalNominal(2);
        test.setNumRelationalNumeric(2);
        test.setNumRelationalString(2);
        try {
            data = test.generate();
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractHashableInstanceTestCase.fail((String)("Failed to generate test data: " + e));
            data = null;
        }
        for (i = 0; i < data.numInstances(); ++i) {
            dense = new DenseInstance(data.get(i));
            dense.setDataset(data);
            sparse = new SparseInstance(data.get(i));
            sparse.setDataset(data);
            this.checkHashStaysSame((Instance)dense, (Instance)sparse);
        }
    }

    public void testEquals() {
        Instances data;
        TestInstances test = new TestInstances();
        try {
            data = test.generate();
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractHashableInstanceTestCase.fail((String)("Failed to generate test data: " + e));
            data = null;
        }
        DenseInstance dense = new DenseInstance(data.get(0));
        dense.setDataset(data);
        SparseInstance sparse = new SparseInstance(data.get(0));
        sparse.setDataset(data);
        AbstractHashableInstanceTestCase.assertFalse((String)"null", (boolean)dense.equals(null));
        AbstractHashableInstanceTestCase.assertTrue((String)"same object (dense)", (boolean)this.wrap((Instance)dense, false, false).equals((Object)this.wrap((Instance)dense, false, false)));
        AbstractHashableInstanceTestCase.assertTrue((String)"same object (sparse)", (boolean)this.wrap((Instance)sparse, false, false).equals((Object)this.wrap((Instance)sparse, false, false)));
    }

    public void testSerializable() {
        SerializedObject obj;
        Instances data;
        TestInstances test = new TestInstances();
        try {
            data = test.generate();
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractHashableInstanceTestCase.fail((String)("Failed to generate test data: " + e));
            data = null;
        }
        try {
            obj = new SerializedObject((Object)this.wrap(data.get(0), false, false));
            obj.getObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractHashableInstanceTestCase.fail((String)("Failed to serialize instance: " + e));
        }
        try {
            obj = new SerializedObject((Object)this.wrap(data.get(0), true, false));
            obj.getObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractHashableInstanceTestCase.fail((String)("Failed to serialize instance (no class): " + e));
        }
        try {
            obj = new SerializedObject((Object)this.wrap(data.get(0), false, true));
            obj.getObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractHashableInstanceTestCase.fail((String)("Failed to serialize instance (no weight): " + e));
        }
        try {
            obj = new SerializedObject((Object)this.wrap(data.get(0), true, true));
            obj.getObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractHashableInstanceTestCase.fail((String)("Failed to serialize instance (no class+weight): " + e));
        }
    }

    static {
        AdamsTestHelper.setRegressionRoot();
    }
}

