/*
 * Decompiled with CFR 0.152.
 */
package adams.core.discovery.genetic;

import adams.core.Utils;
import adams.core.discovery.PropertyPath;
import adams.core.discovery.genetic.AbstractGeneticDiscoveryHandler;
import adams.core.discovery.genetic.WekaGeneticHelper;
import weka.core.matrix.Matrix;

public abstract class AbstractGeneticDoubleMatrixDiscoveryHandler
extends AbstractGeneticDiscoveryHandler {
    private static final long serialVersionUID = 765007046767066355L;
    protected double m_Minimum;
    protected double m_Maximum;
    protected int m_Rows;
    protected int m_Columns;
    protected int m_Splits;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("minimum", "minimum", (Object)this.getDefaultMinimum());
        this.m_OptionManager.add("maximum", "maximum", (Object)this.getDefaultMaximum());
        this.m_OptionManager.add("splits", "splits", (Object)this.getDefaultSplits());
        this.m_OptionManager.add("rows", "rows", (Object)this.getDefaultRows());
        this.m_OptionManager.add("columns", "columns", (Object)this.getDefaultColumns());
    }

    protected abstract int getDefaultSplits();

    public void setSplits(int value) {
        if (this.getOptionManager().isValid("splits", (Number)value)) {
            this.m_Splits = value;
            this.reset();
        }
    }

    public int getSplits() {
        return this.m_Splits;
    }

    public String splitsTipText() {
        return "The number of doubles to use between max and min.";
    }

    protected abstract int getDefaultRows();

    protected abstract int getDefaultColumns();

    protected abstract double getDefaultMinimum();

    public void setColumns(int value) {
        if (this.getOptionManager().isValid("columns", (Number)value)) {
            this.m_Columns = value;
            this.reset();
        }
    }

    public int getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The columns to use.";
    }

    public void setRows(int value) {
        if (this.getOptionManager().isValid("rows", (Number)value)) {
            this.m_Rows = value;
            this.reset();
        }
    }

    public int getRows() {
        return this.m_Rows;
    }

    public String rowsTipText() {
        return "The rows to use.";
    }

    public void setMinimum(double value) {
        if (this.getOptionManager().isValid("minimum", (Number)value)) {
            this.m_Minimum = value;
            this.reset();
        }
    }

    public double getMinimum() {
        return this.m_Minimum;
    }

    public String minimumTipText() {
        return "The minimum to use.";
    }

    protected abstract double getDefaultMaximum();

    public void setMaximum(double value) {
        if (this.getOptionManager().isValid("maximum", (Number)value)) {
            this.m_Maximum = value;
            this.reset();
        }
    }

    public double getMaximum() {
        return this.m_Maximum;
    }

    public String maximumTipText() {
        return "The maximum to use.";
    }

    protected abstract Matrix getValue(PropertyPath.PropertyContainer var1);

    protected String doPack(PropertyPath.PropertyContainer cont) {
        return WekaGeneticHelper.matrixToBits(this.getValue(cont), this.getMinimum(), this.getMaximum(), this.calcNumBits(), this.getSplits(), this.getRows(), this.getColumns());
    }

    protected abstract void setValue(PropertyPath.PropertyContainer var1, Matrix var2);

    protected void doUnpack(PropertyPath.PropertyContainer cont, String bits) {
        this.setValue(cont, WekaGeneticHelper.bitsToMatrix(bits, this.getMinimum(), this.getMaximum(), this.calcNumBits(), this.getSplits(), this.getRows(), this.getColumns()));
    }

    protected int calcNumBits() {
        return (int)(Math.floor(Utils.log2((int)this.m_Splits)) + 1.0);
    }

    public int getNumBits() {
        return this.calcNumBits() * this.getRows() * this.getColumns();
    }
}

