/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.data.weka.WekaLabelIndex;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JComponent;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.core.Attribute;
import weka.core.Instances;
import weka.gui.beans.CostBenefitAnalysis;
import weka.gui.visualize.PlotData2D;

public class WekaCostBenefitAnalysis
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = 3247255046513744115L;
    protected WekaLabelIndex m_ClassIndex;
    protected CostBenefitAnalysis m_CostBenefitPanel;

    public String globalInfo() {
        return "Actor for displaying a cost benefit analysis dialog.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "classIndex", (Object)new WekaLabelIndex("first"));
    }

    protected int getDefaultWidth() {
        return 1200;
    }

    protected int getDefaultHeight() {
        return 700;
    }

    public void setClassIndex(WekaLabelIndex value) {
        this.m_ClassIndex = value;
        this.reset();
    }

    public WekaLabelIndex getClassIndex() {
        return this.m_ClassIndex;
    }

    public String classIndexTipText() {
        return "The range of class label indices (eg used for AUC).";
    }

    public void clearPanel() {
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        this.m_CostBenefitPanel = new CostBenefitAnalysis();
        result.add((Component)this.m_CostBenefitPanel, (Object)"Center");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Evaluation.class, WekaEvaluationContainer.class};
    }

    protected void display(Token token) {
        try {
            Evaluation eval = token.getPayload() instanceof WekaEvaluationContainer ? (Evaluation)((WekaEvaluationContainer)((Object)token.getPayload())).getValue("Evaluation") : (Evaluation)token.getPayload();
            if (eval.predictions() == null) {
                this.getLogger().severe("No predictions available from Evaluation object!");
                return;
            }
            Attribute classAtt = eval.getHeader().classAttribute();
            this.m_ClassIndex.setData(classAtt);
            int classValue = this.m_ClassIndex.getIntIndex();
            ThresholdCurve tc = new ThresholdCurve();
            Instances result = tc.getCurve(eval.predictions(), classValue);
            Attribute classAttToUse = eval.getHeader().classAttribute();
            if (classValue != 0) {
                ArrayList<String> newNames = new ArrayList<String>();
                newNames.add(classAtt.value(classValue));
                for (int k = 0; k < classAtt.numValues(); ++k) {
                    if (k == classValue) continue;
                    newNames.add(classAtt.value(k));
                }
                classAttToUse = new Attribute(classAtt.name(), newNames);
            }
            PlotData2D tempd = new PlotData2D(result);
            tempd.setPlotName(result.relationName());
            tempd.m_alwaysDisplayPointsOfThisSize = 10;
            boolean[] cp = new boolean[result.numInstances()];
            for (int n = 1; n < cp.length; ++n) {
                cp[n] = true;
            }
            tempd.setConnectPoints(cp);
            this.m_CostBenefitPanel.setCurveData(tempd, classAttToUse);
        }
        catch (Exception e) {
            this.handleException("Failed to display token: " + token, e);
        }
    }

    protected void cleanUpGUI() {
        super.cleanUpGUI();
        if (this.m_CostBenefitPanel != null) {
            this.m_CostBenefitPanel = null;
        }
    }

    protected Evaluation getEvaluation(Token token) {
        if (token.getPayload() instanceof WekaEvaluationContainer) {
            return (Evaluation)((WekaEvaluationContainer)((Object)token.getPayload())).getValue("Evaluation");
        }
        return (Evaluation)token.getPayload();
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        String name = token != null ? "Cost curve (" + this.getEvaluation(token).getHeader().relationName() + ")" : "Cost curve";
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel(name){
            private static final long serialVersionUID = -3513994354297811163L;
            protected CostBenefitAnalysis m_VisualizePanel;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_VisualizePanel = new CostBenefitAnalysis();
                this.add((Component)this.m_VisualizePanel, "Center");
            }

            public void display(Token token) {
                try {
                    Evaluation eval = WekaCostBenefitAnalysis.this.getEvaluation(token);
                    Attribute classAtt = eval.getHeader().classAttribute();
                    WekaCostBenefitAnalysis.this.m_ClassIndex.setData(classAtt);
                    int classValue = WekaCostBenefitAnalysis.this.m_ClassIndex.getIntIndex();
                    ThresholdCurve tc = new ThresholdCurve();
                    Instances result = tc.getCurve(eval.predictions(), classValue);
                    Attribute classAttToUse = eval.getHeader().classAttribute();
                    if (classValue != 0) {
                        ArrayList<String> newNames = new ArrayList<String>();
                        newNames.add(classAtt.value(classValue));
                        for (int k = 0; k < classAtt.numValues(); ++k) {
                            if (k == classValue) continue;
                            newNames.add(classAtt.value(k));
                        }
                        classAttToUse = new Attribute(classAtt.name(), newNames);
                    }
                    PlotData2D tempd = new PlotData2D(result);
                    tempd.setPlotName(result.relationName());
                    tempd.m_alwaysDisplayPointsOfThisSize = 10;
                    boolean[] cp = new boolean[result.numInstances()];
                    for (int n = 1; n < cp.length; ++n) {
                        cp[n] = true;
                    }
                    tempd.setConnectPoints(cp);
                    this.m_VisualizePanel.setCurveData(tempd, classAttToUse);
                }
                catch (Exception e) {
                    WekaCostBenefitAnalysis.this.getLogger().log(Level.SEVERE, "Failed to display token: " + token, (Throwable)e);
                }
            }

            public JComponent supplyComponent() {
                return this.m_VisualizePanel;
            }

            public void clearPanel() {
            }

            public void cleanUp() {
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return true;
    }
}

