/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.Shortening;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSourceWithPropertiesUpdating;
import weka.associations.Apriori;
import weka.associations.Associator;

public class WekaAssociatorSetup
extends AbstractSimpleSourceWithPropertiesUpdating {
    private static final long serialVersionUID = -3019442578354930841L;
    protected Associator m_Associator;

    public String globalInfo() {
        return "Outputs an instance of the specified associator.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("associator", "associator", (Object)new Apriori());
    }

    public void setAssociator(Associator value) {
        this.m_Associator = value;
        this.reset();
    }

    public Associator getAssociator() {
        return this.m_Associator;
    }

    public String associatorTipText() {
        return "The Weka associator to train on the input data.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        if (!result.isEmpty()) {
            result = result + ", ";
        }
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"associator", (Object)Shortening.shortenEnd((String)OptionUtils.getShortCommandLine((Object)this.m_Associator), (int)40));
        return result;
    }

    public Class[] generates() {
        return new Class[]{Associator.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            Associator cls = (Associator)OptionUtils.shallowCopy((Object)this.m_Associator);
            result = this.setUpContainersIfNecessary(cls);
            if (result == null) {
                result = this.updateObject(cls);
            }
            if (result == null) {
                this.m_OutputToken = new Token((Object)cls);
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to create copy of associator:", e);
        }
        return result;
    }
}

