/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Utils;
import adams.data.statistics.StatUtils;
import adams.flow.container.WekaPredictionContainer;
import adams.flow.core.AbstractModelLoader;
import adams.flow.core.Token;
import adams.flow.core.WekaClassifierModelLoader;
import adams.flow.transformer.AbstractProcessWekaInstanceWithModel;
import java.util.List;
import weka.classifiers.AbstainingClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.RangeCheckClassifier;
import weka.core.Instance;

public class WekaClassifying
extends AbstractProcessWekaInstanceWithModel<Classifier> {
    private static final long serialVersionUID = -3019442578354930841L;
    protected boolean m_OutputInstance;

    public String globalInfo() {
        return "Uses a serialized model to perform predictions on the data being passed through.\n" + this.m_ModelLoader.automaticOrderInfo();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-instance", "outputInstance", (Object)false);
    }

    @Override
    protected AbstractModelLoader newModelLoader() {
        return new WekaClassifierModelLoader();
    }

    public void setOutputInstance(boolean value) {
        this.m_OutputInstance = value;
        this.reset();
    }

    public boolean getOutputInstance() {
        return this.m_OutputInstance;
    }

    public String outputInstanceTipText() {
        return "Whether to output weka.core.Instance objects or PredictionContainer objects.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{WekaPredictionContainer.class, Instance.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Token processInstance(Instance inst) throws Exception {
        Token result;
        WekaPredictionContainer cont;
        Classifier classifier = (Classifier)this.m_Model;
        synchronized (classifier) {
            AbstainingClassifier abstain;
            double[] distribution;
            double classification;
            List<String> rangeChecks;
            String rangeCheck = null;
            if (this.m_Model instanceof RangeCheckClassifier && (rangeChecks = ((RangeCheckClassifier)this.m_Model).checkRangeForInstance(inst)).size() > 0) {
                rangeCheck = Utils.flatten(rangeChecks, (String)"\n");
            }
            if (inst.classAttribute().isNumeric()) {
                classification = ((Classifier)this.m_Model).classifyInstance(inst);
                distribution = new double[]{classification};
            } else {
                distribution = ((Classifier)this.m_Model).distributionForInstance(inst);
                if (distribution[(int)Math.round(classification = (double)StatUtils.maxIndex((double[])distribution))] == 0.0) {
                    classification = weka.core.Utils.missingValue();
                }
            }
            cont = new WekaPredictionContainer(inst, classification, distribution, rangeCheck);
            if (this.m_Model instanceof AbstainingClassifier && (abstain = (AbstainingClassifier)this.m_Model).canAbstain()) {
                if (inst.classAttribute().isNumeric()) {
                    classification = abstain.getAbstentionClassification(inst);
                    distribution = new double[]{classification};
                } else {
                    distribution = abstain.getAbstentionDistribution(inst);
                    if (distribution[(int)Math.round(classification = (double)StatUtils.maxIndex((double[])distribution))] == 0.0) {
                        classification = weka.core.Utils.missingValue();
                    }
                }
                cont.setValue("Abstention classification", classification);
                if (inst.classAttribute().isNominal() && !weka.core.Utils.isMissingValue((double)classification)) {
                    cont.setValue("Abstention classification label", inst.classAttribute().value((int)Math.round(classification)));
                }
                cont.setValue("Abstention distribution", distribution);
            }
        }
        if (this.m_OutputInstance) {
            inst = (Instance)((Instance)cont.getValue("Instance")).copy();
            inst.setClassValue(((Double)cont.getValue("Classification")).doubleValue());
            result = new Token((Object)inst);
        } else {
            result = new Token((Object)cont);
        }
        return result;
    }
}

