/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Shortening;
import adams.core.Utils;
import adams.core.base.BaseText;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaClusterEvaluationContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.clusterers.ClusterEvaluation;

public class WekaClusterEvaluationSummary
extends AbstractTransformer {
    private static final long serialVersionUID = 8082115424369061977L;
    protected BaseText m_Comment;

    public String globalInfo() {
        return "Generates a summary string of the weka.clusterers.ClusterEvaluation objects that it receives.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("comment", "comment", (Object)new BaseText(""));
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"comment", this.m_Comment.stringValue().length() > 0 ? Shortening.shortenEnd((String)this.m_Comment.stringValue(), (int)20) : null);
    }

    public Class[] accepts() {
        return new Class[]{ClusterEvaluation.class, WekaClusterEvaluationContainer.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    public void setComment(BaseText value) {
        this.m_Comment = value;
        this.reset();
    }

    public BaseText getComment() {
        return this.m_Comment;
    }

    public String commentTipText() {
        return "An optional comment to output in the summary.";
    }

    protected String doExecute() {
        String result = null;
        ClusterEvaluation eval = null;
        Double log = null;
        if (this.m_InputToken.getPayload() instanceof WekaClusterEvaluationContainer) {
            eval = (ClusterEvaluation)((WekaClusterEvaluationContainer)((Object)this.m_InputToken.getPayload())).getValue("Evaluation");
            if (eval == null) {
                log = (Double)((WekaClusterEvaluationContainer)((Object)this.m_InputToken.getPayload())).getValue("Log-likelohood");
            }
        } else {
            eval = (ClusterEvaluation)this.m_InputToken.getPayload();
        }
        StringBuilder buffer = new StringBuilder();
        boolean prolog = false;
        if (this.m_Comment.getValue().length() > 0) {
            String[] comment = this.m_Comment.getValue().split("\n");
            if (comment.length == 1) {
                buffer.append("Comment: " + this.m_Comment + "\n");
            } else {
                buffer.append("Comment:\n");
                for (String line : comment) {
                    buffer.append(line + "\n");
                }
            }
            prolog = true;
        }
        if (prolog) {
            buffer.append("\n");
        }
        if (eval != null) {
            buffer.append(eval.clusterResultsToString());
        } else if (log != null) {
            buffer.append("Log-likelihood: " + Utils.doubleToString((double)log, (int)6));
        }
        this.m_OutputToken = new Token((Object)buffer.toString());
        return result;
    }
}

