/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.License;
import adams.core.QuickInfoHelper;
import adams.core.annotation.MixedCopyright;
import adams.core.option.OptionHandler;
import adams.data.instancesanalysis.PCA;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.core.Instances;

@MixedCopyright(author="Michael Fowke", license=License.GPL3, copyright="2014 Dutch Sprouts, Wageningen, NL")
public class WekaPrincipalComponents
extends AbstractTransformer {
    private static final long serialVersionUID = -3079556702775500196L;
    protected double m_CoverVariance;
    protected int m_MaxAttributes;
    protected int m_MaxAttributeNames;

    public String globalInfo() {
        return "Performs principal components analysis on the incoming data and outputs the loadings and the transformed data as spreadsheet array.\nAutomatically filters out attributes that cannot be handled by PCA.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("variance-covered", "varianceCovered", (Object)0.95);
        this.m_OptionManager.add("max-attributes", "maximumAttributes", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("max-attribute-names", "maximumAttributeNames", (Object)5, (Number)-1, null);
    }

    public void setVarianceCovered(double value) {
        this.m_CoverVariance = value;
        this.reset();
    }

    public double getVarianceCovered() {
        return this.m_CoverVariance;
    }

    public String varianceCoveredTipText() {
        return "Retain enough PC attributes to account for this proportion of variance.";
    }

    public void setMaximumAttributes(int value) {
        this.m_MaxAttributes = value;
        this.reset();
    }

    public int getMaximumAttributes() {
        return this.m_MaxAttributes;
    }

    public String maximumAttributesTipText() {
        return "The maximum number of PC attributes to retain.";
    }

    public void setMaximumAttributeNames(int value) {
        this.m_MaxAttributeNames = value;
        this.reset();
    }

    public int getMaximumAttributeNames() {
        return this.m_MaxAttributeNames;
    }

    public String maximumAttributeNamesTipText() {
        return "The maximum number of attribute names to use.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"varianceCovered", (Object)this.m_CoverVariance, (String)"var: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"maxAttributes", (Object)this.m_MaxAttributes, (String)", max attr: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"maxAttributeNames", (Object)this.m_MaxAttributeNames, (String)", max names: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet[].class};
    }

    protected String doExecute() {
        Instances input = (Instances)this.m_InputToken.getPayload();
        PCA pca = new PCA();
        pca.setVariance(this.m_CoverVariance);
        pca.setMaxAttributes(this.m_MaxAttributes);
        pca.setMaxAttributeNames(this.m_MaxAttributeNames);
        String result = pca.analyze(input);
        if (result == null) {
            this.m_OutputToken = new Token((Object)new SpreadSheet[]{pca.getLoadings(), pca.getScores()});
        }
        return result;
    }
}

