/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.weka.WekaAttributeIndex;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.core.Instance;

public class WekaSetInstanceValue
extends AbstractTransformer {
    private static final long serialVersionUID = -4710366291340930250L;
    protected WekaAttributeIndex m_Index;
    protected String m_Value;

    public String globalInfo() {
        return "Sets a value in a WEKA Instance.\nNotes:\n- relational values cannot be set\n- '?' (without single quotes) is interpreted as missing value";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "index", (Object)new WekaAttributeIndex("last"));
        this.m_OptionManager.add("value", "value", (Object)"?");
    }

    protected void initialize() {
        super.initialize();
        this.m_Index = new WekaAttributeIndex("last");
    }

    public void setIndex(WekaAttributeIndex value) {
        this.m_Index = value;
        this.reset();
    }

    public WekaAttributeIndex getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The 1-based index to set the value for in the WEKA Instance.";
    }

    public void setValue(String value) {
        this.m_Value = value;
        this.reset();
    }

    public String getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The value to set in the WEKA Instance.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"index", (Object)((Object)this.m_Index));
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"value", (Object)this.m_Value, (String)" -> ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instance.class};
    }

    public Class[] generates() {
        return new Class[]{Instance.class};
    }

    protected String doExecute() {
        String result = null;
        Instance inst = (Instance)this.m_InputToken.getPayload();
        inst = (Instance)inst.copy();
        this.m_Index.setData(inst.dataset());
        int index = this.m_Index.getIntIndex();
        try {
            if (this.m_Value.equals("?")) {
                inst.setMissing(index);
            } else {
                switch (inst.attribute(index).type()) {
                    case 0: {
                        inst.setValue(index, Utils.toDouble((String)this.m_Value).doubleValue());
                        break;
                    }
                    case 3: {
                        inst.setValue(index, inst.attribute(index).parseDate(this.m_Value));
                        break;
                    }
                    case 1: 
                    case 2: {
                        inst.setValue(index, this.m_Value);
                        break;
                    }
                    case 4: {
                        result = "Relational attributes cannot be set!";
                        break;
                    }
                    default: {
                        result = "Unhandled attribute type: " + inst.attribute(index).type();
                    }
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to set value: " + this.m_Index.getIndex() + " -> " + this.m_Value, e);
        }
        if (result == null) {
            this.m_OutputToken = new Token((Object)inst);
        }
        return result;
    }
}

