/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.wekaclusterer;

import adams.flow.transformer.wekaclusterer.AbstractClusterMembershipPostProcessor;
import java.util.logging.Level;
import weka.clusterers.Clusterer;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Add;

public class AddCluster
extends AbstractClusterMembershipPostProcessor {
    private static final long serialVersionUID = 5983792992620091051L;
    public static final String PREDICTED_CLUSTER = "Predicted cluster";
    public static final String PREDICTED_DISTRIBUTION = "Predicted distribution";
    protected boolean m_OutputDistribution;

    public String globalInfo() {
        return "Just adds the predicted cluster (or distribution) to the original dataset.\nStored in container under: Clustered dataset";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-distribution", "outputDistribution", (Object)false);
    }

    public void setOutputDistribution(boolean value) {
        this.m_OutputDistribution = value;
        this.reset();
    }

    public boolean getOutputDistribution() {
        return this.m_OutputDistribution;
    }

    public String outputDistributionTipText() {
        return "If enabled, the cluster distribution is output instead of the cluster index.";
    }

    @Override
    protected Instances processDatasetWithClusterer(Instances data, Clusterer clusterer) {
        Instances result;
        block16: {
            block15: {
                int n;
                int numClusters;
                if (!this.m_OutputDistribution) break block15;
                try {
                    numClusters = clusterer.numberOfClusters();
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to query number of clusters!", (Throwable)e);
                    numClusters = 0;
                }
                result = data;
                for (n = 0; n < numClusters; ++n) {
                    Add add = new Add();
                    add.setAttributeType(new SelectedTag(0, Add.TAGS_TYPE));
                    add.setAttributeName("Predicted distribution " + n);
                    add.setAttributeIndex("" + (result.numAttributes() + 1));
                    try {
                        add.setInputFormat(result);
                        result = Filter.useFilter((Instances)result, (Filter)add);
                    }
                    catch (Exception e) {
                        this.getLogger().log(Level.SEVERE, "Failed to add attribute 'Predicted distribution " + n + "' to the dataset!", (Throwable)e);
                        result = null;
                    }
                    if (result == null) break;
                }
                if (result == null) break block16;
                for (int i = 0; i < data.numInstances(); ++i) {
                    try {
                        double[] dist = clusterer.distributionForInstance(data.instance(i));
                        for (n = 0; n < numClusters; ++n) {
                            result.instance(i).setValue(result.numAttributes() - numClusters + n, dist[n]);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        this.getLogger().log(Level.SEVERE, "Failed to cluster instance #" + (i + 1) + "!", (Throwable)e);
                    }
                }
                break block16;
            }
            Add add = new Add();
            add.setAttributeType(new SelectedTag(0, Add.TAGS_TYPE));
            add.setAttributeName(PREDICTED_CLUSTER);
            add.setAttributeIndex("" + (data.numAttributes() + 1));
            try {
                add.setInputFormat(data);
                result = Filter.useFilter((Instances)data, (Filter)add);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to add attribute 'Predicted cluster' to the dataset!", (Throwable)e);
                result = null;
            }
            if (result != null) {
                for (int i = 0; i < data.numInstances(); ++i) {
                    try {
                        int cluster = clusterer.clusterInstance(data.instance(i));
                        result.instance(i).setValue(result.numAttributes() - 1, (double)cluster);
                        continue;
                    }
                    catch (Exception e) {
                        this.getLogger().log(Level.SEVERE, "Failed to cluster instance #" + (i + 1) + "!", (Throwable)e);
                    }
                }
            }
        }
        return result;
    }
}

