/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.wekaensemblegenerator;

import adams.core.ObjectCopyHelper;
import adams.core.Utils;
import adams.flow.transformer.wekaensemblegenerator.AbstractWekaEnsembleGenerator;
import weka.classifiers.Classifier;
import weka.classifiers.MultipleClassifiersCombiner;
import weka.classifiers.meta.AbstainVote;

public class MultiClassifiersCombinerModels
extends AbstractWekaEnsembleGenerator {
    private static final long serialVersionUID = -7876743086471307294L;
    protected MultipleClassifiersCombiner m_Template;

    public String globalInfo() {
        return "Generates a MultipleClassifiersCombiner meta-classifier from the incoming pre-built classifier models.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("template", "template", (Object)new AbstainVote());
    }

    public void setTemplate(MultipleClassifiersCombiner value) {
        this.m_Template = value;
        this.reset();
    }

    public MultipleClassifiersCombiner getTemplate() {
        return this.m_Template;
    }

    public String voteTipText() {
        return "The template of the MultipleClassifiersCombiner classifier to use.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Classifier[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{MultipleClassifiersCombiner.class};
    }

    @Override
    protected String check(Object input) {
        String result = super.check(input);
        if (result == null && !(input instanceof Classifier[])) {
            result = "Input does not represent a classifier array (" + Utils.classToString(Classifier[].class) + ")!";
        }
        return result;
    }

    @Override
    protected Object doGenerate(Object input) {
        Classifier[] classifiers = (Classifier[])input;
        MultipleClassifiersCombiner result = (MultipleClassifiersCombiner)ObjectCopyHelper.copyObject((Object)this.m_Template);
        result.setClassifiers(classifiers);
        return result;
    }
}

