/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.datatable.action;

import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.datatable.action.AbstractEditableDataTableAction;
import java.awt.event.ActionEvent;

public class Revert
extends AbstractEditableDataTableAction {
    private static final long serialVersionUID = -8374323161691034031L;

    public Revert() {
        this.setName("Revert");
        this.setIcon("revert.png");
        this.setAsynchronous(true);
    }

    protected void doActionPerformed(ActionEvent e) {
        for (DataContainer cont : this.getSelectedData()) {
            if (!cont.isModified() || !cont.canReload()) continue;
            this.logMessage("Reverting dataset: " + cont.getID() + "/" + cont.getData().relationName() + " [" + cont.getSource() + "]");
            if (cont.reload()) {
                this.getOwner().getOwner().updateClassAttribute(cont.getData());
                this.logMessage("Successfully reverted " + cont.getID() + "!");
                this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner().getOwner(), 4, this.getData().indexOf(cont)));
                continue;
            }
            this.logMessage("Failed to revert!");
        }
    }

    @Override
    public void update() {
        this.setEnabled(!this.isBusy() && this.getTable().getSelectedRowCount() > 0);
    }
}

