/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab;

import adams.core.MessageCollection;
import adams.data.conversion.SpreadSheetToWekaInstances;
import adams.data.conversion.WekaInstancesToSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.db.SQLStatement;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanelWithButtons;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.RecentSQLStatementsHandler;
import adams.gui.core.SpreadSheetQueryEditorPanel;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.help.HelpFrame;
import adams.gui.tools.wekainvestigator.data.MemoryContainer;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTabWithDataTable;
import adams.parser.SpreadSheetQuery;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.table.TableModel;
import weka.core.Instances;

public class DataQueryTab
extends AbstractInvestigatorTabWithDataTable {
    private static final long serialVersionUID = -4106630131554796889L;
    public static final String SESSION_FILE = "WekaInvestigatorDataQueries.props";
    public static final String KEY_QUERY = "query";
    protected SpreadSheetQueryEditorPanel m_PanelQuery;
    protected BaseButton m_ButtonExecute;
    protected BaseButton m_ButtonClear;
    protected BaseButton m_ButtonHistory;
    protected BaseButton m_ButtonHelp;
    protected BaseButton m_ButtonSave;
    protected SpreadSheetTable m_TableResult;
    protected boolean m_DataGenerated;
    protected JPopupMenu m_PopupMenu;
    protected RecentSQLStatementsHandler<JPopupMenu> m_RecentStatementsHandler;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_DataGenerated = false;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_PanelData.setLayout(new BorderLayout());
        BaseSplitPane splitPane = new BaseSplitPane(0);
        splitPane.setDividerLocation(150);
        splitPane.setUISettingsParameters(this.getClass(), "divider");
        this.m_PanelData.add((Component)splitPane, "Center");
        BasePanelWithButtons panelTop = new BasePanelWithButtons();
        this.m_PanelQuery = new SpreadSheetQueryEditorPanel();
        this.m_PanelQuery.setText("SELECT *");
        this.m_PanelQuery.addChangeListener(e -> this.updateButtons());
        panelTop.add((Component)this.m_PanelQuery, (Object)"Center");
        this.m_ButtonExecute = new BaseButton((Icon)GUIHelper.getIcon((String)"run.gif"));
        this.m_ButtonExecute.setToolTipText("Executes the query on the selected dataset");
        this.m_ButtonExecute.addActionListener(e -> this.executeQuery());
        panelTop.addToButtonsPanel((Component)this.m_ButtonExecute);
        this.m_ButtonHistory = new BaseButton((Icon)GUIHelper.getIcon((String)"history.png"));
        this.m_ButtonHistory.setToolTipText("Recent queries");
        this.m_ButtonHistory.addActionListener(e -> this.m_PopupMenu.show((Component)this.m_ButtonHistory, 0, this.m_ButtonHistory.getHeight()));
        panelTop.addToButtonsPanel((Component)this.m_ButtonHistory);
        this.m_ButtonClear = new BaseButton((Icon)GUIHelper.getIcon((String)"new.gif"));
        this.m_ButtonClear.setToolTipText("Removes the previously generated result");
        this.m_ButtonClear.addActionListener(e -> this.clear());
        panelTop.addToButtonsPanel((Component)this.m_ButtonClear);
        this.m_ButtonSave = new BaseButton((Icon)GUIHelper.getIcon((String)"save.gif"));
        this.m_ButtonSave.setToolTipText("Stores the result as a new dataset");
        this.m_ButtonSave.addActionListener(e -> this.saveDataset());
        panelTop.addToButtonsPanel((Component)this.m_ButtonSave);
        this.m_ButtonHelp = new BaseButton((Icon)GUIHelper.getIcon((String)"help.gif"));
        this.m_ButtonHelp.setToolTipText("Help screen for the query language");
        this.m_ButtonHelp.addActionListener(e -> this.showHelp());
        panelTop.addToButtonsPanel((Component)this.m_ButtonHelp);
        splitPane.setTopComponent((Component)panelTop);
        this.m_TableResult = new SpreadSheetTable(new SpreadSheetTableModel());
        this.m_TableResult.setShowSimplePopupMenus(true);
        splitPane.setBottomComponent((Component)new BaseScrollPane((Component)this.m_TableResult));
        this.m_SplitPane.setBottomComponentHidden(false);
        this.m_PopupMenu = new JPopupMenu();
        this.m_RecentStatementsHandler = new RecentSQLStatementsHandler(SESSION_FILE, 10, (Object)this.m_PopupMenu);
        this.m_RecentStatementsHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JPopupMenu, SQLStatement>(){

            public void recentItemAdded(RecentItemEvent<JPopupMenu, SQLStatement> e) {
            }

            public void recentItemSelected(RecentItemEvent<JPopupMenu, SQLStatement> e) {
                DataQueryTab.this.setStatement((SQLStatement)e.getItem());
            }
        });
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.clear();
        this.updateButtons();
    }

    @Override
    public String getTitle() {
        return "Data query";
    }

    @Override
    public String getTabIcon() {
        return "dataquery.png";
    }

    @Override
    protected boolean hasReadOnlyTable() {
        return true;
    }

    @Override
    protected int getDataTableListSelectionMode() {
        return 0;
    }

    @Override
    public void dataChanged(WekaInvestigatorDataEvent e) {
        super.dataChanged(e);
        this.dataTableSelectionChanged();
    }

    @Override
    protected void dataTableSelectionChanged() {
        this.updateButtons();
    }

    protected void executeQuery() {
        if (this.getData().size() != 1) {
            return;
        }
        WekaInstancesToSpreadSheet conv = new WekaInstancesToSpreadSheet();
        conv.setInput(this.getData().get(0).getData());
        String msg = conv.convert();
        if (msg != null) {
            this.logError(msg, "Failed to turn dataset into spreadsheet!");
            return;
        }
        SpreadSheet current = (SpreadSheet)conv.getOutput();
        conv.cleanUp();
        String query = this.m_PanelQuery.getQuery().getValue();
        try {
            SpreadSheet generated = SpreadSheetQuery.evaluate((String)query, new HashMap(), (SpreadSheet)current);
            this.m_RecentStatementsHandler.addRecentItem((Object)new SQLStatement(this.m_PanelQuery.getContent()));
            this.m_TableResult.setModel((TableModel)new SpreadSheetTableModel(generated));
            this.m_DataGenerated = true;
        }
        catch (Exception e) {
            this.clear();
            this.logError("Failed to execute query:\n" + query, e, "Data query failed");
        }
        this.updateButtons();
    }

    protected void saveDataset() {
        if (!this.m_DataGenerated) {
            return;
        }
        SpreadSheetToWekaInstances conv = new SpreadSheetToWekaInstances();
        conv.setInput(this.m_TableResult.toSpreadSheet());
        String msg = conv.convert();
        if (msg != null) {
            this.logError(msg, "Conversion failed!");
            conv.cleanUp();
            return;
        }
        String name = this.m_PanelQuery.getQuery().getValue().replace("\n", " ");
        if ((name = GUIHelper.showInputDialog((Component)((Object)this), (String)"Please enter relation name", (String)name)) == null) {
            return;
        }
        Instances newData = (Instances)conv.getOutput();
        newData.setRelationName(name);
        conv.cleanUp();
        MemoryContainer newCont = new MemoryContainer(newData);
        this.getData().add(newCont);
        this.logMessage("Added query result as " + newCont.getID() + "!");
        this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner(), 2, this.getData().size() - 1));
    }

    protected void clear() {
        this.m_TableResult.setModel((TableModel)new SpreadSheetTableModel());
        this.m_DataGenerated = false;
    }

    protected void showHelp() {
        HelpFrame.showHelp((String)SpreadSheetQuery.class.getName(), (String)new SpreadSheetQuery().getGrammar(), (boolean)false);
    }

    public void setStatement(SQLStatement value) {
        this.m_PanelQuery.setContent(value.getValue());
    }

    protected void updateButtons() {
        this.m_ButtonExecute.setEnabled(this.getSelectedRows().length == 1 && !this.m_PanelQuery.getQuery().isEmpty());
        this.m_ButtonClear.setEnabled(this.m_DataGenerated);
        this.m_ButtonSave.setEnabled(this.m_ButtonExecute.isEnabled() && this.m_DataGenerated);
    }

    @Override
    protected Map<String, Object> doSerialize(Set<AbstractInvestigatorTab.SerializationOption> options) {
        Map<String, Object> result = super.doSerialize(options);
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.PARAMETERS)) {
            result.put(KEY_QUERY, this.m_PanelQuery.getText());
        }
        return result;
    }

    @Override
    protected void doDeserialize(Map<String, Object> data, MessageCollection errors) {
        super.doDeserialize(data, errors);
        if (data.containsKey(KEY_QUERY)) {
            this.m_PanelQuery.setText((String)data.get(KEY_QUERY));
        }
    }
}

